/*
 * Experiments.cpp
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */
#include <Experiments.h>

#define BENCHMARK_PHASE_1 1
#define BENCHMARK_PHASE_2 2

#ifdef IGRAPH_VERSION_0_6_5
#define BENCHMARK_FILE_PATH "/home/nino/EPI_code/Results/Benchmark/"
#define REALIZATIONS_FILE_PATH "/home/nino/EPI_code/Results/RealizationsDynamic/"
#else
#define BENCHMARK_FILE_PATH "/home/nino/ssd/EPI_code/Results/Benchmark/"
#define REALIZATIONS_FILE_PATH "/home/nino/ssd/EPI_code/Results/RealizationsDynamic/"
#endif

#define BENCHMARK_REAL_MAX_SIZE 55
#define BENCHMARK_REAL_MIN_SIZE 5
#define RANKING_REALIZATION_MIN_RATIO 0.01
#define MASTER_GENERATE_REALIZATION 1
#define MASTER_READ_REALIZATION 2


void run_MPI_benchmark_experiment(int argc, char **argv) {

	int mpi_kontrola, mpi_size, mpi_rank;
    mpi_kontrola = MPI_Init(&argc, &argv);
    if (mpi_kontrola != MPI_SUCCESS) {
        printf("ERROR MPI COULD NOT START \n");
        MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
    }
    MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

    // *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);

	vector<double> T_distr_experiments, P_distr_experiments, Q_distr_experiments; //double T_disr_param = 0.4;
	//load_geometric_distribution(0.5, &T_distr_experiments); //note that sample should not be resampled -> each process needs same value
	//load_B_distribution(2,2, &Q_distr_experiments); load_B_distribution(2,2, &P_distr_experiments);
	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure

	int exp_OFFSET_create = 280; // if we want to continue creating realizations but to give them offset on index, put 0 when BENCHMARK_PHASE_2
	int exp_low_id = 0; // experiment start index
	int exp_high_id = 288; // ! Maximal number of realizations used only in BENCHMARK_PHASE_2
	int benchmark_phase = BENCHMARK_PHASE_1;
	vector<long int> num_simulations_array_exp;
	if ( benchmark_phase == BENCHMARK_PHASE_1 ){
		//add_sim_num_for_benchmark_convergence(&num_simulations_array_exp, 7, 8); //exponential growth
		add_sim_num_for_phase1(&num_simulations_array_exp, 6, 8); // linear growth + exponential
	}else{
		add_sim_num_for_benchmark_convergence(&num_simulations_array_exp, 1, 5);
	}

	vector<likelihood_struct> likelihood_array;
	add_likelihoods_to_benchmark(benchmark_phase, &likelihood_array);
	char *fileBenchMarkPath = BENCHMARK_FILE_PATH;

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_UNWEIGHTED_NET;
	double * likelihood_last = NULL;
	if (mpi_rank == COLLECTOR_PROCESS_ID){
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
		likelihood_last = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
	}
	//PQ grid + T
	for(int num_real = 0; num_real < 100; ++num_real){
		for(double p = 0.3; p < 1.0; p += 0.4){
			for(double q = 0.3; q < 1.0 ; q+= 0.4){
				P_distr_experiments.push_back(p);
				Q_distr_experiments.push_back(q);
				T_distr_experiments.push_back(5);
			}
		}
	}
	// *** Input parameters END

	int converged_prob_distr, master_generate_real;
	for( int estimator_idx = 0; estimator_idx < likelihood_array.size(); estimator_idx++){
		contagion_param_struct epidemicParameters_exp;

		for(int exp_idx = exp_low_id; exp_idx < ( (benchmark_phase == BENCHMARK_PHASE_1) ? P_distr_experiments.size(): exp_high_id ); exp_idx++){
			if (benchmark_phase == BENCHMARK_PHASE_1){
				epidemicParameters_exp.p = P_distr_experiments.at(exp_idx); //epidemicParameters_exp.p = get_random_sample( &P_distr_experiments); // all nodes will have same value !!!
				epidemicParameters_exp.q = Q_distr_experiments.at(exp_idx); //epidemicParameters_exp.q = get_random_sample( &Q_distr_experiments); // note that  T_distr_sample_noise and norm_distr_sample_noise are empty we have no noise !!!
				epidemicParameters_exp.T = T_distr_experiments.at(exp_idx); //epidemicParameters_exp.T = epidemicParameters.T_value_min + T_distr_experiments.at(exp_idx);
				converged_prob_distr = 0;
			}
			for ( int sim_num_idx = 0; sim_num_idx < num_simulations_array_exp.size(); sim_num_idx++){
				if ((sim_num_idx == 0) && (benchmark_phase == BENCHMARK_PHASE_1) ){ // First time generate realization
					master_generate_real = MASTER_GENERATE_REALIZATION;
				}else{ // read realization
					master_generate_real = MASTER_READ_REALIZATION;
				}
				input_args.no_of_iteration_per_cycle = num_simulations_array_exp.at(sim_num_idx);
				statistic_parameters.no_of_iteration_per_cycle = num_simulations_array_exp.at(sim_num_idx);

				MPI_benchmark_single_estimator_single_exp( &input_args, mpi_rank, mpi_size, exp_OFFSET_create + exp_idx, master_generate_real , &epidemicParameters_exp, p_infected_parameters, &statistic_parameters ,&likelihood_array.at(estimator_idx) ,fileBenchMarkPath);

				if (benchmark_phase == BENCHMARK_PHASE_1){
					if (mpi_rank == COLLECTOR_PROCESS_ID){ // before here was abs error term with fun: source_prob_distr_converged
						if ((sim_num_idx>0) && source_prob_distr_ML_converged(statistic_parameters.likelihoodAll, likelihood_last, p_infected_parameters->no_of_nodes, 0.05)){
							converged_prob_distr = 1;
							printf("Probability distribution converged ! \n"); fflush(stdout);
						}
						MPI_Bcast( &converged_prob_distr, 1, MPI_INT, COLLECTOR_PROCESS_ID, MPI_COMM_WORLD); // propagate decision (0/1) to others
						copy_likelihood_vector(statistic_parameters.likelihoodAll, likelihood_last, p_infected_parameters->no_of_nodes);
					}else{
						MPI_Bcast( &converged_prob_distr, 1, MPI_INT, COLLECTOR_PROCESS_ID, MPI_COMM_WORLD); // recieve decision
					}
					if (converged_prob_distr == 1){
						break;
					}
				}
			}

			if ((benchmark_phase == BENCHMARK_PHASE_1)&&(converged_prob_distr == 0)){ // if the relalization did not converged for specific pqT, repeat
				P_distr_experiments.push_back(epidemicParameters_exp.p);
				Q_distr_experiments.push_back(epidemicParameters_exp.q);
				T_distr_experiments.push_back(epidemicParameters_exp.T);
			}
		}// experiments for pq values
	} // likelihood estimators

	if (likelihood_last != NULL){ free(likelihood_last); }
	num_simulations_array_exp.clear();
	P_distr_experiments.clear();
	Q_distr_experiments.clear();
	T_distr_experiments.clear();
	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	likelihood_array.clear();
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void MPI_benchmark_single_estimator_single_exp(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileBenchMarkPath){

	MPI_Barrier(MPI_COMM_WORLD); //sync all machines

	//double * likelihoodsAll;
	igraph_vector_t * realization_star;
	int source_node_id;
	if (mpi_rank == MASTER_PROCESS_ID) {
		if ( master_generate_real == MASTER_GENERATE_REALIZATION ){
			int realization_size_cond = 0;
			printf("\n Generate realization: Method %d, Phi %d , experiment: %d, likelihood_param: %lf, sim_num: %010ld \n", likelihood_tmp->likelihood_method, likelihood_tmp->phi_type, exp_idx, likelihood_tmp->likelihood_param.first, input_args->no_of_iteration_per_cycle);
			while( !realization_size_cond ){

				realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
				igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes); //***HEAP-MEMORY SAFE
				source_node_id = getRandomNode( p_infected_parameters->no_of_nodes );
				p_infected_parameters->start_node = source_node_id;
				struct timeval tv; gettimeofday(&tv, 0); unsigned seed = tv.tv_usec * getpid();

				run_contagion_model(p_infected_parameters, statistic_parameters->contagion_process_type, realization_star, epidemicParameters_exp, seed);
				int no_of_inf_nodes = igraph_vector_sum(realization_star);
				if ( ( no_of_inf_nodes >= BENCHMARK_REAL_MIN_SIZE ) && ( no_of_inf_nodes <= BENCHMARK_REAL_MAX_SIZE ) ){
					realization_size_cond = 1;
				}else{
					igraph_vector_destroy(realization_star);
					free(realization_star);
				}
			}
			export_realization(realization_star, exp_idx, source_node_id, epidemicParameters_exp, fileBenchMarkPath);
			//void export_realization(igraph_vector_t * realization, int realization_id, int source_id, contagion_param_struct *cont_param, char * filePath)
		}else if (master_generate_real == MASTER_READ_REALIZATION){
			// master read - read realization
			realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
			igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes);
			read_benchmark_realization(realization_star, exp_idx, fileBenchMarkPath, &source_node_id);
			read_realization_pqT( epidemicParameters_exp, exp_idx, fileBenchMarkPath);
		}else{
			printf("parameter master_generate_real not set coretlly !\n"); fflush(stdout);
			exit(-1);
		}
		printf("\n ------ Method %d, Phi %d , experiment: %d, likelihood_param: %lf, sim_num: %010ld \n", likelihood_tmp->likelihood_method, likelihood_tmp->phi_type, exp_idx, likelihood_tmp->likelihood_param.first, input_args->no_of_iteration_per_cycle);
		printf(" p: %f, q: %f , T: %d \n ",epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T);
		printf("Source node: %d \n", source_node_id);
		int no_of_start_nodes = igraph_vector_sum( realization_star );
		printf("Realization size: %d \n", no_of_start_nodes);

		int * nodes_set = (int *) malloc((no_of_start_nodes+1) * sizeof(int)); //***HEAP-MEMORY SAFE
		int tmpNum = 0;
		for (int i=0; i< igraph_vector_size( realization_star ); ++i){
			if (VECTOR( *realization_star )[i]==1){
				nodes_set[tmpNum++] = i;
			}
		}

		MPI_Barrier(MPI_COMM_WORLD);

		mpi_rank = master_process_likelihood_singles(mpi_size, mpi_rank, no_of_start_nodes, nodes_set, source_node_id);
		free(nodes_set);
		igraph_vector_destroy( realization_star );
	} else if (mpi_rank == COLLECTOR_PROCESS_ID){

		MPI_Barrier(MPI_COMM_WORLD);

		read_realization_pqT( epidemicParameters_exp, exp_idx, fileBenchMarkPath);
		clock_t t;
		t = clock();
		mpi_rank = collector_process_likelihood_singles(input_args, p_infected_parameters, mpi_rank, statistic_parameters, exp_idx, likelihood_tmp);
		t = clock() - t;
		double exe_time_ms = ((double)t) / ((double)(CLOCKS_PER_SEC / 1000));
		export_source_prob(p_infected_parameters, statistic_parameters->likelihoodAll, fileBenchMarkPath, exp_idx, input_args->no_of_iteration_per_cycle, input_args->input_file_name, likelihood_tmp, exe_time_ms);
	}else{
		MPI_Barrier(MPI_COMM_WORLD);
		read_realization_pqT( epidemicParameters_exp, exp_idx, fileBenchMarkPath);
		mpi_rank = worker_process_likelihood_singles( mpi_rank, input_args, p_infected_parameters, statistic_parameters ,epidemicParameters_exp, likelihood_tmp);
	}
}

void run_MPI_ranking_Temporal_Net_experiment (int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n"); MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);
	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	char * fileRealizationsPath = REALIZATIONS_FILE_PATH;
	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE //only for init of other structures
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure
	epidemicParameters.T_rel_end = 300; //moment of oberving the realization
	epidemicParameters.T_end = p_infected_parameters->zero_time + epidemicParameters.T_rel_end;
	//start time will be chosen from interval [100-200] in deterministic way
	int master_start_time_lower = 10; //on cunchy test hypothesis of initial start
	int master_start_time_high = 200;

	int exp_low_id = 0; int exp_high_id = 500;
	likelihood_struct likelihood_tmp; likelihood_tmp.phi_type = PHI_JACCARD; likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN; likelihood_tmp.likelihood_param = make_pair(0.125,-1.0);

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO;
	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
		FILE *fp = fopen("Likelihood_experiments_statistics.txt","w");
		fprintf(fp, "#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high T_0\n");
		fclose(fp);

		fp = fopen("Experiment_log.txt","w");
		fclose(fp);
	}
	vector<int> delta_array;
	delta_array.push_back(200);delta_array.push_back(120);delta_array.push_back(60);delta_array.push_back(30);delta_array.push_back(0);

	vector<double> P_distr_experiments, Q_distr_experiments; //P_distr_experiments.push_back(0.5);Q_distr_experiments.push_back(0.02);
	P_distr_experiments.push_back(0.3);Q_distr_experiments.push_back(0.01);
	//P_distr_experiments.push_back(0.8);Q_distr_experiments.push_back(0.05);

	vector<int> prior_T_low, prior_T_high;
	prior_T_low.push_back(0);prior_T_high.push_back(0);
	//prior_T_low.push_back(-25);prior_T_high.push_back(+25);
	//prior_T_low.push_back(-50);prior_T_high.push_back(+50);
	// *** Input parameters END

	int master_generate_real;
	for (int i = 0 ; i < P_distr_experiments.size(); ++i){
		epidemicParameters.p = P_distr_experiments.at(i); epidemicParameters.q = Q_distr_experiments.at(i);
		master_generate_real = MASTER_GENERATE_REALIZATION; // new SIR process, we need new realizations
		for(int delta_idx = 0; delta_idx < delta_array.size(); delta_idx++){
			for(int j = 0; j < prior_T_low.size(); j++){
				infected_structure * p_infected_parameters_exp; //***HEAP-MEMORY SAFE
				p_infected_parameters_exp = (infected_structure *) malloc(sizeof (infected_structure));
				init_infected_structure(&input_args, p_infected_parameters_exp); //load network from begining due to the delta models

				for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
						int master_start_time = master_start_time_lower + (exp_idx % (master_start_time_high-master_start_time_lower));
						epidemicParameters.prior_T_low_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_low.at(j);
						epidemicParameters.prior_T_high_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_high.at(j);
						if (mpi_rank == MASTER_PROCESS_ID) {
							epidemicParameters.T_rel_start = master_start_time; // master will use this was sampling the realizations
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							epidemicParameters.estimate_T_from_temporal_contacts = 0;
							epidemicParameters.randomize_parameters = 0; // T,p,q are random variables
							p_infected_parameters_exp->randomize_temporal_contacts = 0;
							p_infected_parameters_exp->randomize_null_model_uniformly = 0;
							p_infected_parameters_exp->delta = 0;
							p_infected_parameters_exp->sample_random_start_nodes = 1;
							printf("** p %lf, q %lf, DELTA: %d, prior_T_low: %d, prior_T_high_T: %d, t_0 %d \n", epidemicParameters.p, epidemicParameters.q, delta_array[delta_idx], epidemicParameters.prior_T_low_bound, epidemicParameters.prior_T_high_bound, epidemicParameters.T_start);
						}else if (mpi_rank == COLLECTOR_PROCESS_ID){
							epidemicParameters.T_rel_start = master_start_time; // collector also has this value
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}else{
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}


						MPI_ranking_single_experiment( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp, fileRealizationsPath );
						make_experiment_log(mpi_rank, exp_idx, master_generate_real,  &input_args, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp);
						validate_temporal_null_model(mpi_rank, p_infected_parameters_exp, p_infected_parameters, epidemicParameters.T_end);
				}// experiments
				master_generate_real = MASTER_READ_REALIZATION; //first n realizations are created and afterwards we read them only
				destroy_infected_structure(p_infected_parameters_exp);
				free(p_infected_parameters_exp);
			}//priors
		}//delta
	}//pq

	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void run_MPI_ranking_Temporal_Net_ran_sensors_experiment (int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n"); MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);
	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	char * fileRealizationsPath = REALIZATIONS_FILE_PATH;
	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE //only for init of other structures
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure
	epidemicParameters.T_rel_end = 300; //moment of oberving the realization
	epidemicParameters.T_end = p_infected_parameters->zero_time + epidemicParameters.T_rel_end;
	//start time will be chosen from interval [100-200] in deterministic way
	int master_start_time_lower = 100;
	int master_start_time_high = 200;

	int exp_low_id = 0; int exp_high_id = 100;
	likelihood_struct likelihood_tmp; likelihood_tmp.phi_type = PHI_JACCARD; likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN; likelihood_tmp.likelihood_param = make_pair(0.125,-1.0);

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO;
	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
		FILE *fp = fopen("Likelihood_experiments_statistics.txt","w");
		fprintf(fp, "#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high T_0\n");
		fclose(fp);

		fp = fopen("Experiment_log.txt","w");
		fclose(fp);
	}
	vector<int> delta_array;
	delta_array.push_back(0);

	vector<double> P_distr_experiments, Q_distr_experiments;
	P_distr_experiments.push_back(0.3);Q_distr_experiments.push_back(0.01);

	double mask_bit_prob = 0.2;

	vector<int> prior_T_low, prior_T_high;
	prior_T_low.push_back(0);prior_T_high.push_back(0);
	prior_T_low.push_back(-25);prior_T_high.push_back(+25);
	prior_T_low.push_back(-50);prior_T_high.push_back(+50);
	// *** Input parameters END

	int master_generate_real;
	for (int i = 0 ; i < P_distr_experiments.size(); ++i){
		epidemicParameters.p = P_distr_experiments.at(i); epidemicParameters.q = Q_distr_experiments.at(i);
		master_generate_real = MASTER_GENERATE_REALIZATION; // new SIR process, we need new realizations
		for(int delta_idx = 0; delta_idx < delta_array.size(); delta_idx++){
			for(int j = 0; j < prior_T_low.size(); j++){
				infected_structure * p_infected_parameters_exp; //***HEAP-MEMORY SAFE
				p_infected_parameters_exp = (infected_structure *) malloc(sizeof (infected_structure));
				init_infected_structure(&input_args, p_infected_parameters_exp); //load network from begining due to the delta models

				for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
						int master_start_time = master_start_time_lower + (exp_idx % (master_start_time_high-master_start_time_lower));
						epidemicParameters.prior_T_low_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_low.at(j);
						epidemicParameters.prior_T_high_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_high.at(j);
						if (mpi_rank == MASTER_PROCESS_ID) {
							epidemicParameters.T_rel_start = master_start_time; // master will use this was sampling the realizations
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							epidemicParameters.estimate_T_from_temporal_contacts = 0;
							epidemicParameters.randomize_parameters = 0; // T,p,q are random variables
							p_infected_parameters_exp->randomize_temporal_contacts = 0;
							p_infected_parameters_exp->randomize_null_model_uniformly = 0;
							p_infected_parameters_exp->delta = 0;
							p_infected_parameters_exp->sample_random_start_nodes = 1;
							printf("** p %lf, q %lf, DELTA: %d, prior_T_low: %d, prior_T_high_T: %d, t_0 %d \n", epidemicParameters.p, epidemicParameters.q, delta_array[delta_idx], epidemicParameters.prior_T_low_bound, epidemicParameters.prior_T_high_bound, epidemicParameters.T_start);
						}else if (mpi_rank == COLLECTOR_PROCESS_ID){
							epidemicParameters.T_rel_start = master_start_time; // collector also has this value
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}else{
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}


						//MPI_ranking_single_experiment( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp, fileRealizationsPath );
						MPI_ranking_mask_sync_single_experiment(&input_args, mpi_rank, mpi_size, exp_idx, master_generate_real, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp, fileRealizationsPath, 1,  mask_bit_prob );
						make_experiment_log(mpi_rank, exp_idx, master_generate_real,  &input_args, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp);
						validate_temporal_null_model(mpi_rank, p_infected_parameters_exp, p_infected_parameters, epidemicParameters.T_end);
				}// experiments
				master_generate_real = MASTER_READ_REALIZATION; //first n realizations are created and afterwards we read them only
				destroy_infected_structure(p_infected_parameters_exp);
				free(p_infected_parameters_exp);
			}//priors
		}//delta
	}//pq

	if (mpi_rank == COLLECTOR_PROCESS_ID){
		free(statistic_parameters.likelihoodAll);
	}

	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void run_MPI_ranking_Temporal_Net_convergence_experiment (int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n"); MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);
	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	char * fileRealizationsPath = REALIZATIONS_FILE_PATH;
	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE //only for init of other structures
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure
	epidemicParameters.T_rel_end = 300; //moment of oberving the realization
	epidemicParameters.T_end = p_infected_parameters->zero_time + epidemicParameters.T_rel_end;
	//start time will be chosen from interval [100-200] in deterministic way
	int master_start_time_lower = 100; //on cunchy test hypothesis of initial start
	int master_start_time_high = 200;

	int exp_low_id = 0; int exp_high_id = 5;
	likelihood_struct likelihood_tmp; likelihood_tmp.phi_type = PHI_JACCARD; likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN; likelihood_tmp.likelihood_param = make_pair(0.125,-1.0);

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO;
	double * likelihood_last;
	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
		likelihood_last = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
		FILE *fp = fopen("Likelihood_experiments_statistics.txt","w");
		fprintf(fp, "#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high T_0\n");
		fclose(fp);

		fp = fopen("Experiment_log.txt","w");
		fclose(fp);
	}
	vector<int> delta_array;
	delta_array.push_back(200);delta_array.push_back(120);delta_array.push_back(60);delta_array.push_back(30);delta_array.push_back(0);

	vector<double> P_distr_experiments, Q_distr_experiments; //P_distr_experiments.push_back(0.5);Q_distr_experiments.push_back(0.02);
	P_distr_experiments.push_back(0.3);Q_distr_experiments.push_back(0.01);
	//P_distr_experiments.push_back(0.8);Q_distr_experiments.push_back(0.05);

	vector<int> prior_T_low, prior_T_high;
	prior_T_low.push_back(0);prior_T_high.push_back(0);
	//prior_T_low.push_back(-25);prior_T_high.push_back(+25);
	//prior_T_low.push_back(-50);prior_T_high.push_back(+50);
	// *** Input parameters END

	int sim_num_base = statistic_parameters.no_of_iteration_per_cycle;
	int master_generate_real;
	for (int i = 0 ; i < P_distr_experiments.size(); ++i){
		epidemicParameters.p = P_distr_experiments.at(i); epidemicParameters.q = Q_distr_experiments.at(i);
		master_generate_real = MASTER_GENERATE_REALIZATION; // new SIR process, we need new realizations
		for(int delta_idx = 0; delta_idx < delta_array.size(); delta_idx++){
			for(int j = 0; j < prior_T_low.size(); j++){
				infected_structure * p_infected_parameters_exp; //***HEAP-MEMORY SAFE
				p_infected_parameters_exp = (infected_structure *) malloc(sizeof (infected_structure));
				init_infected_structure(&input_args, p_infected_parameters_exp); //load network from begining due to the delta models

				for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
						int master_start_time = master_start_time_lower + (exp_idx % (master_start_time_high-master_start_time_lower));
						epidemicParameters.prior_T_low_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_low.at(j);
						epidemicParameters.prior_T_high_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_high.at(j);
						if (mpi_rank == MASTER_PROCESS_ID) {
							epidemicParameters.T_rel_start = master_start_time; // master will use this was sampling the realizations
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							epidemicParameters.estimate_T_from_temporal_contacts = 0;
							epidemicParameters.randomize_parameters = 0; // T,p,q are random variables
							p_infected_parameters_exp->randomize_temporal_contacts = 0;
							p_infected_parameters_exp->randomize_null_model_uniformly = 0;
							p_infected_parameters_exp->delta = 0;
							p_infected_parameters_exp->sample_random_start_nodes = 1;
							printf("** p %lf, q %lf, DELTA: %d, prior_T_low: %d, prior_T_high_T: %d, t_0 %d \n", epidemicParameters.p, epidemicParameters.q, delta_array[delta_idx], epidemicParameters.prior_T_low_bound, epidemicParameters.prior_T_high_bound, epidemicParameters.T_start);
						}else if (mpi_rank == COLLECTOR_PROCESS_ID){
							epidemicParameters.T_rel_start = master_start_time; // collector also has this value
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}else{
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}

						int converged_ML_rank = 0;
						int master_generate_real_conv;
						int sim_num_base = statistic_parameters.no_of_iteration_per_cycle;
						for (int sim_num = 1; sim_num <= 10; ++ sim_num){
							if ( (sim_num==1) && (master_generate_real == MASTER_GENERATE_REALIZATION) ){ // be carefull this is DKA
								//only first time fro convergence we genereate new otherwise we read
								master_generate_real_conv = MASTER_GENERATE_REALIZATION;
							}else{
								master_generate_real_conv = MASTER_READ_REALIZATION;
							}
							MPI_ranking_single_experiment( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real_conv, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp, fileRealizationsPath, 0 );
							if (mpi_rank == COLLECTOR_PROCESS_ID){ // num_sim_new in our settings always is sim_num_base !!!
								if (sim_num>1){
									recalc_likelihoods_old_new(statistic_parameters.likelihoodAll, likelihood_last, p_infected_parameters->no_of_nodes, statistic_parameters.no_of_iteration_per_cycle, (sim_num-1)*statistic_parameters.no_of_iteration_per_cycle);
									if (rank_ML_converged(statistic_parameters.likelihoodAll, likelihood_last, p_infected_parameters->no_of_nodes)){
										converged_ML_rank = 1;
										printf("*!*!*!*!* Rank ML converged at %d *!*!*!*!* \n", (sim_num*statistic_parameters.no_of_iteration_per_cycle)); fflush(stdout);
										statistic_parameters.no_of_iteration_per_cycle *= sim_num;
										dump_collector_results(&input_args, mpi_rank, mpi_size, exp_idx, master_generate_real_conv, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp);
									}
								}
								MPI_Bcast( &converged_ML_rank, 1, MPI_INT, COLLECTOR_PROCESS_ID, MPI_COMM_WORLD); // propagate decision (0/1) to others
								copy_likelihood_vector(statistic_parameters.likelihoodAll, likelihood_last, p_infected_parameters->no_of_nodes);
							}else{
								MPI_Bcast( &converged_ML_rank, 1, MPI_INT, COLLECTOR_PROCESS_ID, MPI_COMM_WORLD); // recieve decision
							}
							if (converged_ML_rank == 1){
								break;
							}

						}
						make_experiment_log(mpi_rank, exp_idx, master_generate_real,  &input_args, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp);
						validate_temporal_null_model(mpi_rank, p_infected_parameters_exp, p_infected_parameters, epidemicParameters.T_end);
						statistic_parameters.no_of_iteration_per_cycle = sim_num_base;
				}// experiments
				master_generate_real = MASTER_READ_REALIZATION; //first n realizations are created and afterwards we read them only
				destroy_infected_structure(p_infected_parameters_exp);
				free(p_infected_parameters_exp);
			}//priors
		}//delta
	}//pq

	if (mpi_rank == COLLECTOR_PROCESS_ID){ free(likelihood_last); }
	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void run_MPI_ranking_Temporal_Net_convergence_soft_a_range_experiment (int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n"); MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);
	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	char * fileRealizationsPath = REALIZATIONS_FILE_PATH;
	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE //only for init of other structures
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure
	epidemicParameters.T_rel_end = 300; //moment of oberving the realization
	epidemicParameters.T_end = p_infected_parameters->zero_time + epidemicParameters.T_rel_end;
	//start time will be chosen from interval [100-200] in deterministic way
	int master_start_time_lower = 100; //on cunchy test hypothesis of initial start
	int master_start_time_high = 200;

	int exp_low_id = 0; int exp_high_id = 500;
	likelihood_struct likelihood_tmp; likelihood_tmp.phi_type = PHI_JACCARD; likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN_A_RANGE; likelihood_tmp.likelihood_param = make_pair(-1.0,-1.0);

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO;
	double * likelihood_last;FILE *fp;
	vector<double*> likelihood_last_a_array;
	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
		likelihood_last = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
		fp = fopen("Likelihood_experiments_statistics.txt","w");
		fprintf(fp, "#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high T_0 Diam_InfGraph\n");
		fclose(fp);
		fp = fopen("Experiment_log.txt","w");fclose(fp);

		fp = fopen("Experiment_times.txt","w");fprintf(fp, "#exp_id time[ms] \n");fclose(fp);

		double sigma = 1;
		for (int k = 0; k<10; ++k){
			sigma = sigma / 2;
			statistic_parameters.a_array.push_back(sigma);
			double * likelihood_a_tmp = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double));
			statistic_parameters.a_array_likelihoods.push_back(likelihood_a_tmp);

			double * likelihood_a_tmp_last = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double));
			likelihood_last_a_array.push_back(likelihood_a_tmp_last);
		}
	}
	//init likelihood_struct for all mpi_ranks
	double sigma = 1;
	for (int k = 0; k<10; ++k){
		sigma = sigma / 2;
		likelihood_tmp.a_array.push_back(sigma);
		likelihood_tmp.likelihood_theta_a_array.push_back(0.0);
	}

	vector<int> delta_array;
	delta_array.push_back(0);//delta_array.push_back(15);delta_array.push_back(30);//delta_array.push_back(60);//delta_array.push_back(120);delta_array.push_back(200);

	vector<double> P_distr_experiments, Q_distr_experiments; //P_distr_experiments.push_back(0.5);Q_distr_experiments.push_back(0.02);
	P_distr_experiments.push_back(0.3);Q_distr_experiments.push_back(0.01);
	//P_distr_experiments.push_back(0.8);Q_distr_experiments.push_back(0.05);

	vector<int> prior_T_low, prior_T_high;
	prior_T_low.push_back(0);prior_T_high.push_back(0);
	//prior_T_low.push_back(-25);prior_T_high.push_back(+25);
	//prior_T_low.push_back(-50);prior_T_high.push_back(+50);
	// *** Input parameters END

	int sim_num_base = statistic_parameters.no_of_iteration_per_cycle;
	int master_generate_real;
	clock_t t;
	for (int i = 0 ; i < P_distr_experiments.size(); ++i){
		epidemicParameters.p = P_distr_experiments.at(i); epidemicParameters.q = Q_distr_experiments.at(i);
		master_generate_real = MASTER_GENERATE_REALIZATION; // new SIR process, we need new realizations
		for(int delta_idx = 0; delta_idx < delta_array.size(); delta_idx++){
			for(int j = 0; j < prior_T_low.size(); j++){
				infected_structure * p_infected_parameters_exp; //***HEAP-MEMORY SAFE
				p_infected_parameters_exp = (infected_structure *) malloc(sizeof (infected_structure));
				init_infected_structure(&input_args, p_infected_parameters_exp); //load network from begining due to the delta models

				for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
						int master_start_time = master_start_time_lower + (exp_idx % (master_start_time_high-master_start_time_lower));
						epidemicParameters.prior_T_low_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_low.at(j);
						epidemicParameters.prior_T_high_bound = p_infected_parameters_exp->zero_time + master_start_time + prior_T_high.at(j);
						if (mpi_rank == MASTER_PROCESS_ID) {
							epidemicParameters.T_rel_start = master_start_time; // master will use this was sampling the realizations
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							epidemicParameters.estimate_T_from_temporal_contacts = 0;
							epidemicParameters.randomize_parameters = 0; // T,p,q are random variables
							p_infected_parameters_exp->randomize_temporal_contacts = 0;
							p_infected_parameters_exp->delta = 0;
							p_infected_parameters_exp->sample_random_start_nodes = 1;
							printf("** p %lf, q %lf, DELTA: %d, prior_T_low: %d, prior_T_high_T: %d, t_0 %d \n", epidemicParameters.p, epidemicParameters.q, delta_array[delta_idx], epidemicParameters.prior_T_low_bound, epidemicParameters.prior_T_high_bound, epidemicParameters.T_start);
						}else if (mpi_rank == COLLECTOR_PROCESS_ID){
							epidemicParameters.T_rel_start = master_start_time; // collector also has this value
							epidemicParameters.T_start = p_infected_parameters->zero_time + epidemicParameters.T_rel_start;
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}else{
							p_infected_parameters_exp->delta = delta_array.at(delta_idx);
							p_infected_parameters_exp->randomize_temporal_contacts = 1;
							//p_infected_parameters_exp->randomize_null_model_uniformly = 1; //use uniform null model, not permutation
							p_infected_parameters_exp->randomize_null_model_uniformly = 0; //!!!PERMUTATION MODEL
							epidemicParameters.estimate_T_from_temporal_contacts = 1;
							epidemicParameters.randomize_parameters = 1; // T,p,q are random variables
						}

						int converged_ML_rank = 0;
						int master_generate_real_conv;
						int sim_num_base = statistic_parameters.no_of_iteration_per_cycle;
						int a_idx_min_converged_global = -1;int sim_num_maks = 4;
						double simulation_time_ms = 0.0;
						for (int sim_num = 1; sim_num <= sim_num_maks; ++ sim_num){
							t = clock();
							if ( (sim_num==1) && (master_generate_real == MASTER_GENERATE_REALIZATION) ){ // be carefull this is DKA
								//only first time fro convergence we genereate new otherwise we read
								master_generate_real_conv = MASTER_GENERATE_REALIZATION;
							}else{
								master_generate_real_conv = MASTER_READ_REALIZATION;
							}
							MPI_ranking_single_experiment( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real_conv, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp, fileRealizationsPath, 0 );
							if (mpi_rank == COLLECTOR_PROCESS_ID){ // num_sim_new in our settings always is sim_num_base !!!
								if (sim_num>1){
									int a_idx_min_converged = -1;
									for (int a_idx = 0; a_idx<statistic_parameters.a_array_likelihoods.size(); ++a_idx){
										recalc_likelihoods_old_new(statistic_parameters.a_array_likelihoods.at(a_idx), likelihood_last_a_array.at(a_idx), p_infected_parameters->no_of_nodes, statistic_parameters.no_of_iteration_per_cycle, (sim_num-1)*statistic_parameters.no_of_iteration_per_cycle);

										// rank_ML_converged(statistic_parameters.a_array_likelihoods.at(a_idx), likelihood_last_a_array.at(a_idx), p_infected_parameters->no_of_nodes)
										if (source_prob_distr_ML_converged(statistic_parameters.a_array_likelihoods.at(a_idx), likelihood_last_a_array.at(a_idx), p_infected_parameters->no_of_nodes,0.05)){
											a_idx_min_converged = a_idx;
										}
									}
									if (a_idx_min_converged >= 0){//as a are put in decreasing order the last one is the minimal
										printf("*!**!*!*! a_idx = %d a = %lf converged at sim num: %d \n", a_idx_min_converged, likelihood_tmp.a_array.at(a_idx_min_converged), sim_num*statistic_parameters.no_of_iteration_per_cycle);fflush(stdout);
										a_idx_min_converged_global = a_idx_min_converged;
									}
								}
								if(sim_num == sim_num_maks){
									copy_likelihood_vector(statistic_parameters.a_array_likelihoods.at(a_idx_min_converged_global), statistic_parameters.likelihoodAll , p_infected_parameters->no_of_nodes);
									int diam_tmp = find_diameter_temporal_subgraph(p_infected_parameters, statistic_parameters.observed_realization);
									statistic_parameters.diameter_inf_subgraph = diam_tmp;
									printf("--D-- diameter of temporal infected subgraph %d --D--, total number of nodes N %d \n", diam_tmp, p_infected_parameters_exp->no_of_nodes);
									dump_collector_results(&input_args, mpi_rank, mpi_size, exp_idx, master_generate_real_conv, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp);
								}
								MPI_Bcast( &converged_ML_rank, 1, MPI_INT, COLLECTOR_PROCESS_ID, MPI_COMM_WORLD); // propagate decision (0/1) to others
								for (int a_idx = 0; a_idx<statistic_parameters.a_array_likelihoods.size(); ++a_idx){
									copy_likelihood_vector(statistic_parameters.a_array_likelihoods.at(a_idx), likelihood_last_a_array.at(a_idx), p_infected_parameters->no_of_nodes);
								}

								t = clock() - t;
								double exe_time_ms_tmp = ((double)t) / ((double)(CLOCKS_PER_SEC / 1000));
								simulation_time_ms += exe_time_ms_tmp;

								fp = fopen("Experiment_times.txt","a");
								fprintf(fp, "%lf ", exp_idx, simulation_time_ms);
								if (sim_num == sim_num_maks) fprintf(fp, " %d \n", exp_idx);
								fclose(fp);
							}else{
								MPI_Bcast( &converged_ML_rank, 1, MPI_INT, COLLECTOR_PROCESS_ID, MPI_COMM_WORLD); // recieve decision
							}
							if (converged_ML_rank == 1){
								break;
							}

						}
						if (mpi_rank == COLLECTOR_PROCESS_ID){

						}

						make_experiment_log(mpi_rank, exp_idx, master_generate_real,  &input_args, &epidemicParameters, p_infected_parameters_exp, &statistic_parameters, &likelihood_tmp);
						validate_temporal_null_model(mpi_rank, p_infected_parameters_exp, p_infected_parameters, epidemicParameters.T_end);
						statistic_parameters.no_of_iteration_per_cycle = sim_num_base;
				}// experiments
				master_generate_real = MASTER_READ_REALIZATION; //first n realizations are created and afterwards we read them only
				destroy_infected_structure(p_infected_parameters_exp);
				free(p_infected_parameters_exp);
			}//priors
		}//delta
	}//pq

	if (mpi_rank == COLLECTOR_PROCESS_ID){
		free(likelihood_last);
		statistic_parameters.a_array.clear();
		for (int k = 0; k<statistic_parameters.a_array_likelihoods.size(); ++k){
			free(statistic_parameters.a_array_likelihoods.at(k));
			free(likelihood_last_a_array.at(k));
		}
		statistic_parameters.a_array_likelihoods.clear();
	}
	likelihood_tmp.a_array.clear();likelihood_tmp.likelihood_theta_a_array.clear();
	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void dump_collector_results(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp){

	int realization_size = -1;int MLnode_dist, source_rank, ML_node_id;
	MLnode_dist = find_ML_distance_to_source( statistic_parameters->likelihoodAll, p_infected_parameters, mpi_rank, &ML_node_id);
	source_rank = get_source_rank(statistic_parameters->likelihoodAll, p_infected_parameters); //source rank is writen in p_infected_parameters by collector node !
	FILE *fp = fopen("Likelihood_experiments_statistics.txt","a"); // no topological boost
	//#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high T_0 Diam_InfGraph\n");
	printf("MOBY %lf %lf \n", epidemicParameters_exp->p, epidemicParameters_exp->q);
	fprintf(fp, "%d %d %d %lf %lf %d %d %d %d %d %d %d %d %d %d %d\n", source_rank, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method, epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->delta, MLnode_dist, ML_node_id, statistic_parameters->realization_size, p_infected_parameters->randomize_null_model_uniformly, 0, epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound , epidemicParameters_exp->T_start, statistic_parameters->diameter_inf_subgraph);
	fclose(fp);

	double * neighbourhood_prob = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
	calculate_neighbourhood_prob( neighbourhood_prob, statistic_parameters->likelihoodAll, p_infected_parameters ); //only for nodes that have non-zero source prob
	MLnode_dist = find_ML_distance_to_source(neighbourhood_prob, p_infected_parameters, mpi_rank, &ML_node_id);
	source_rank = get_source_rank(neighbourhood_prob, p_infected_parameters);

	fp = fopen("Likelihood_experiments_statistics.txt","a"); // with topological boost
	fprintf(fp, "%d %d %d %lf %lf %d %d %d %d %d %d %d %d %d %d %d\n", source_rank, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method, epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->delta, MLnode_dist, ML_node_id, statistic_parameters->realization_size, p_infected_parameters->randomize_null_model_uniformly, 1 , epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound, epidemicParameters_exp->T_start, statistic_parameters->diameter_inf_subgraph);
	fclose(fp);

	printf("Source rank : %d , size %d \n", source_rank, statistic_parameters->realization_size ); fflush(stdout);
	free(neighbourhood_prob);
}

void run_MPI_ranking_Avio_experiment (int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n"); MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);
	contagion_param_struct epidemicParameters;

	set_epidemic_parameters(&input_args, &epidemicParameters);
	char * fileRealizationsPath = REALIZATIONS_FILE_PATH;

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE //only for init of other structures
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure

	int exp_low_id = 0; int exp_high_id = 100;

	likelihood_struct likelihood_tmp;
	likelihood_tmp.phi_type = PHI_JACCARD; likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN; likelihood_tmp.likelihood_param = make_pair(0.25,-1.0);

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_WEIGHTED_NET;

	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
		FILE *fp = fopen("Likelihood_experiments_statistics.txt","w");
		fprintf(fp, "#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high\n");
		fclose(fp);

		fp = fopen("Experiment_log.txt","w");
		fclose(fp);
	}
	p_infected_parameters->sample_random_start_nodes = 0;
	vector<int> source_array_id;
	source_array_id.push_back(1053); //,MEX,Mexico City Juarez International Apt
	//source_array_id.push_back(444); //Zagreb airport
	//source_array_id.push_back(582); //LHR,London Heathrow Apt

	// *** Input parameters END

	for(int source_idx = 0; source_idx < source_array_id.size(); ++ source_idx){
		if (mpi_rank == MASTER_PROCESS_ID) {
			p_infected_parameters->start_node = source_array_id.at(source_idx);
		}
		int master_generate_real = MASTER_GENERATE_REALIZATION;
		for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
				MPI_ranking_single_experiment( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real, &epidemicParameters, p_infected_parameters, &statistic_parameters, &likelihood_tmp, fileRealizationsPath );
				make_experiment_log(mpi_rank, exp_idx, master_generate_real,  &input_args, &epidemicParameters, p_infected_parameters, &statistic_parameters, &likelihood_tmp);
		}// experiments
		master_generate_real = MASTER_READ_REALIZATION;
	}

	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void run_MPI_ranking_static_net_experiment (int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n"); MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size); MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);
	contagion_param_struct epidemicParameters;

	set_epidemic_parameters(&input_args, &epidemicParameters);
	char * fileRealizationsPath = REALIZATIONS_FILE_PATH;

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE //only for init of other structures
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure

	int exp_low_id = 0; int exp_high_id = 500;

	likelihood_struct likelihood_tmp;
	likelihood_tmp.phi_type = PHI_JACCARD; likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN; likelihood_tmp.likelihood_param = make_pair(0.125,-1.0);

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_UNWEIGHTED_NET;

	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
		FILE *fp = fopen("Likelihood_experiments_statistics.txt","w");
		fprintf(fp, "#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandomizatioModel TopologicalBoost T_prior_low T_prior_high\n");
		fclose(fp);

		fp = fopen("Experiment_log.txt","w");
		fclose(fp);
	}
	p_infected_parameters->sample_random_start_nodes = 1;
	// *** Input parameters END

	int master_generate_real = MASTER_GENERATE_REALIZATION;
	for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
			MPI_ranking_single_experiment( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real, &epidemicParameters, p_infected_parameters, &statistic_parameters, &likelihood_tmp, fileRealizationsPath );
			make_experiment_log(mpi_rank, exp_idx, master_generate_real,  &input_args, &epidemicParameters, p_infected_parameters, &statistic_parameters, &likelihood_tmp);
	}// experiments
	master_generate_real = MASTER_READ_REALIZATION;


	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}

void MPI_ranking_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileRealizationsPath){

	//call function, with default parameter 1 for int collector_write_res -> write results to file
	MPI_ranking_single_experiment(input_args, mpi_rank, mpi_size, exp_idx, master_generate_real,  epidemicParameters_exp, p_infected_parameters, statistic_parameters, likelihood_tmp, fileRealizationsPath, 1);

}

void MPI_ranking_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileRealizationsPath, int collector_write_res){

	MPI_Barrier(MPI_COMM_WORLD); //sync all machines

	igraph_vector_t * realization_star;
	int source_node_id;
	if (mpi_rank == MASTER_PROCESS_ID) {
		if ( master_generate_real == MASTER_GENERATE_REALIZATION ){
			int realization_size_cond = 0;
			//printf("\n Generate realization: Method %d, Phi %d , experiment: %d, likelihood_param: %lf, sim_num: %010ld \n", likelihood_tmp->likelihood_method, likelihood_tmp->phi_type, exp_idx, likelihood_tmp->likelihood_param.first, input_args->no_of_iteration_per_cycle);
			while( !realization_size_cond ){

				realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
				igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes); //***HEAP-MEMORY SAFE
				if (p_infected_parameters->sample_random_start_nodes == 1){
					if ( p_infected_parameters->use_temporal_network_structure == 1 ){
						int source_node_time_dummy;
						//source_node_id = getRandomNodeFromPeriod(p_infected_parameters, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_rel_start+60, &source_node_time_dummy); // random femaleday
						source_node_id = getRandomNodeFromPeriod(p_infected_parameters, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_rel_start, &source_node_time_dummy);
					}else{
						source_node_id = getRandomNode( p_infected_parameters->no_of_nodes );
					}
					p_infected_parameters->start_node = source_node_id;
				}else{
					source_node_id = p_infected_parameters->start_node; //already set from upper function
				}


				struct timeval tv; gettimeofday(&tv, 0); unsigned seed = tv.tv_usec * getpid();

				run_contagion_model(p_infected_parameters, statistic_parameters->contagion_process_type, realization_star, epidemicParameters_exp, seed);
				int no_of_inf_nodes = igraph_vector_sum(realization_star);
				//printf("num inf nodes : %d out of %d , start node: %d \n", no_of_inf_nodes, p_infected_parameters->no_of_nodes, source_node_id); fflush(stdout);
				if ( (no_of_inf_nodes > ((double) RANKING_REALIZATION_MIN_RATIO * p_infected_parameters->no_of_nodes))){
					realization_size_cond = 1;
				}else{
					igraph_vector_destroy(realization_star);
					free(realization_star);
				}
			}

			export_realization(realization_star, exp_idx, source_node_id, epidemicParameters_exp, fileRealizationsPath);

		}else if (master_generate_real == MASTER_READ_REALIZATION){
			// master read - read realization
			realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
			igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes);
			read_benchmark_realization(realization_star, exp_idx, fileRealizationsPath, &source_node_id);
			p_infected_parameters->start_node = source_node_id;
			read_realization_pqT( epidemicParameters_exp, exp_idx, fileRealizationsPath);
		}else{
			printf("parameter master_generate_real not set coretlly !\n"); fflush(stdout);
			exit(-1);
		}

		printf("\n ******** Method %d, Phi %d , experiment: %d, likelihood_param: %lf, sim_num: %010ld \n", likelihood_tmp->likelihood_method, likelihood_tmp->phi_type, exp_idx, likelihood_tmp->likelihood_param.first, statistic_parameters->no_of_iteration_per_cycle);
		printf(" p: %f, q: %f , T: %d \n ",epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T);
		printf("Source node: %d , start time %d, end_time %d \n", source_node_id, epidemicParameters_exp->T_start, epidemicParameters_exp->T_end);
		int no_of_start_nodes = igraph_vector_sum( realization_star );
		printf("Realization size: %d \n", no_of_start_nodes);

		vector<int> node_activity_check;
		int * nodes_set = (int *) malloc((no_of_start_nodes+1) * sizeof(int)); //***HEAP-MEMORY SAFE
		int tmpNum = 0;

		//printf("Realization Master inf nodes \n"); fflush(stdout);
		for (int i=0; i< igraph_vector_size( realization_star ); ++i){
			if (VECTOR( *realization_star )[i]==1){
				nodes_set[tmpNum++] = i;
				//printf(" %d ", i);fflush(stdout);
				check_master_realization_acitvities(p_infected_parameters, &node_activity_check, epidemicParameters_exp, i);
				node_activity_check.clear();
			}
		}

		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = master_process_likelihood_singles(mpi_size, mpi_rank, no_of_start_nodes, nodes_set, source_node_id);
		free(nodes_set);
		igraph_vector_destroy( realization_star );
	} else if (mpi_rank == COLLECTOR_PROCESS_ID){
		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = collector_process_likelihood_singles(input_args, p_infected_parameters, mpi_rank, statistic_parameters, exp_idx, likelihood_tmp);
		int realization_size = -1;
		int MLnode_dist, source_rank, ML_node_id;

		if (collector_write_res == 1){ //upper function will write the results : iterative convergence of soft margin
			MLnode_dist = find_ML_distance_to_source(statistic_parameters->likelihoodAll, p_infected_parameters, mpi_rank, &ML_node_id);
			source_rank = get_source_rank(statistic_parameters->likelihoodAll, p_infected_parameters); //source rank is writen in p_infected_parameters by collector node !
			FILE *fp = fopen("Likelihood_experiments_statistics.txt","a"); // no topological boost
			//"#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandModel TopologicalBoost T_prior_low\n"
			fprintf(fp, "%d %d %d %lf %lf %d %d %d %d %d %d %d %d %d %d\n", source_rank, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method, epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->delta, MLnode_dist, ML_node_id, statistic_parameters->realization_size, p_infected_parameters->randomize_null_model_uniformly, 0, epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound , epidemicParameters_exp->T_start);
			fclose(fp);

			double * neighbourhood_prob = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
			calculate_neighbourhood_prob( neighbourhood_prob, statistic_parameters->likelihoodAll, p_infected_parameters ); //only for nodes that have non-zero source prob
			MLnode_dist = find_ML_distance_to_source(neighbourhood_prob, p_infected_parameters, mpi_rank, &ML_node_id);
			source_rank = get_source_rank(neighbourhood_prob, p_infected_parameters);
			export_source_prob(p_infected_parameters, neighbourhood_prob, fileRealizationsPath, exp_idx, input_args->no_of_iteration_per_cycle, input_args->input_file_name, likelihood_tmp, -1.0 );

			fp = fopen("Likelihood_experiments_statistics.txt","a"); // with topological boost
			fprintf(fp, "%d %d %d %lf %lf %d %d %d %d %d %d %d %d %d %d\n", source_rank, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method, epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->delta, MLnode_dist, ML_node_id, statistic_parameters->realization_size, p_infected_parameters->randomize_null_model_uniformly, 1 , epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound, epidemicParameters_exp->T_start);
			fclose(fp);

			printf("Source rank : %d , size %d \n", source_rank, statistic_parameters->realization_size ); fflush(stdout);
			free(neighbourhood_prob);
		}

	}else{
		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = worker_process_likelihood_singles( mpi_rank, input_args, p_infected_parameters, statistic_parameters ,epidemicParameters_exp, likelihood_tmp);
	}
}

void MPI_ranking_mask_sync_single_experiment(input *input_args, int mpi_rank, int mpi_size, int exp_idx, int master_generate_real,  contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp, char *fileRealizationsPath, int collector_write_res, double mask_bit_prob){

	MPI_Barrier(MPI_COMM_WORLD); //sync all machines

	igraph_vector_t * realization_star;
	int source_node_id;
	if (mpi_rank == MASTER_PROCESS_ID) {
		if ( master_generate_real == MASTER_GENERATE_REALIZATION ){
			int realization_size_cond = 0;
			//printf("\n Generate realization: Method %d, Phi %d , experiment: %d, likelihood_param: %lf, sim_num: %010ld \n", likelihood_tmp->likelihood_method, likelihood_tmp->phi_type, exp_idx, likelihood_tmp->likelihood_param.first, input_args->no_of_iteration_per_cycle);
			while( !realization_size_cond ){

				realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
				igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes); //***HEAP-MEMORY SAFE
				if (p_infected_parameters->sample_random_start_nodes == 1){
					if ( p_infected_parameters->use_temporal_network_structure == 1 ){
						int source_node_time_dummy;
						//source_node_id = getRandomNodeFromPeriod(p_infected_parameters, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_rel_start+60, &source_node_time_dummy); // random femaleday
						source_node_id = getRandomNodeFromPeriod(p_infected_parameters, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_rel_start, &source_node_time_dummy);
					}else{
						source_node_id = getRandomNode( p_infected_parameters->no_of_nodes );
					}
					p_infected_parameters->start_node = source_node_id;
				}else{
					source_node_id = p_infected_parameters->start_node; //already set from upper function
				}


				struct timeval tv; gettimeofday(&tv, 0); unsigned seed = tv.tv_usec * getpid();

				run_contagion_model(p_infected_parameters, statistic_parameters->contagion_process_type, realization_star, epidemicParameters_exp, seed);
				int no_of_inf_nodes = igraph_vector_sum(realization_star);
				//printf("num inf nodes : %d out of %d , start node: %d \n", no_of_inf_nodes, p_infected_parameters->no_of_nodes, source_node_id); fflush(stdout);
				if ( (no_of_inf_nodes > ((double) RANKING_REALIZATION_MIN_RATIO * p_infected_parameters->no_of_nodes))){
					realization_size_cond = 1;
				}else{
					igraph_vector_destroy(realization_star);
					free(realization_star);
				}
			}

			export_realization(realization_star, exp_idx, source_node_id, epidemicParameters_exp, fileRealizationsPath);

		}else if (master_generate_real == MASTER_READ_REALIZATION){
			// master read - read realization
			realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
			igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes);
			read_benchmark_realization(realization_star, exp_idx, fileRealizationsPath, &source_node_id);
			p_infected_parameters->start_node = source_node_id;
			read_realization_pqT( epidemicParameters_exp, exp_idx, fileRealizationsPath);
		}else{
			printf("parameter master_generate_real not set coretlly !\n"); fflush(stdout);
			exit(-1);
		}

		printf("\n ******** Method %d, Phi %d , experiment: %d, likelihood_param: %lf, sim_num: %010ld \n", likelihood_tmp->likelihood_method, likelihood_tmp->phi_type, exp_idx, likelihood_tmp->likelihood_param.first, statistic_parameters->no_of_iteration_per_cycle);
		printf(" p: %f, q: %f , T: %d \n ",epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T);
		printf("Source node: %d , start time %d, end_time %d \n", source_node_id, epidemicParameters_exp->T_start, epidemicParameters_exp->T_end);
		int no_of_start_nodes = igraph_vector_sum( realization_star );
		printf("Realization size: %d \n", no_of_start_nodes);

		vector<int> node_activity_check;
		//generate mask
		igraph_vector_t mask; //***HEAP-MEMORY SAFE
		igraph_vector_init(&mask, p_infected_parameters->no_of_nodes);
		generate_mask( &mask, mask_bit_prob);
		int mask_list_size = (int) igraph_vector_sum(&mask);
		printf("Mask generated size %d... \n", mask_list_size); fflush(stdout);

		//find potential candidates
		igraph_vector_t realization_candidates; //***HEAP-MEMORY SAFE
		igraph_vector_init(&realization_candidates, p_infected_parameters->no_of_nodes);
		find_potential_candidates(p_infected_parameters, realization_star, &mask, &realization_candidates);
		int num_pot_cand = (int) igraph_vector_sum(&realization_candidates);
		//tranform to primitive structure
		int * nodes_set = (int *) malloc((num_pot_cand+1) * sizeof(int)); //***HEAP-MEMORY SAFE
		printf("Potential candidates found %d ... \n", num_pot_cand); fflush(stdout);

		int *mask_list = (int *) malloc( mask_list_size * sizeof(int) ); //***HEAP-MEMORY SAFE
		int tmpNum = 0; int tmpMaskNum = 0;
		for (int i=0; i< igraph_vector_size( realization_star ); ++i){
			if (VECTOR( realization_candidates )[i]==1){
				nodes_set[tmpNum++] = i;
			}
			if (VECTOR(mask)[i] == 1){
				mask_list[tmpMaskNum++] = i;
			}
		}

		MPI_Barrier(MPI_COMM_WORLD);
		//sync mask
		MPI_Bcast( &mask_list_size, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
		MPI_Bcast ( mask_list, mask_list_size, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
		printf("MASK synced ! ... \n"); fflush(stdout);
		mpi_rank = master_process_likelihood_singles(mpi_size, mpi_rank, num_pot_cand, nodes_set, source_node_id);
		free(nodes_set);
		free(mask_list);
		igraph_vector_destroy( realization_star );
		igraph_vector_destroy(&realization_candidates);
		igraph_vector_destroy(&mask);

	} else if (mpi_rank == COLLECTOR_PROCESS_ID){
		MPI_Barrier(MPI_COMM_WORLD);
		//sync mask
		int mask_list_size;
		MPI_Bcast( &mask_list_size, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
		int *mask_list = (int *) malloc( mask_list_size * sizeof(int) );  //***HEAP-MEMORY SAFE
		MPI_Bcast ( mask_list, mask_list_size, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
		copy_mask_to_statistics_struct( mask_list, mask_list_size, statistic_parameters, p_infected_parameters);
		mpi_rank = collector_process_likelihood_singles(input_args, p_infected_parameters, mpi_rank, statistic_parameters, exp_idx, likelihood_tmp);
		int realization_size = -1;
		int MLnode_dist, source_rank, ML_node_id;

		if (collector_write_res == 1){ //upper function will write the results : iterative convergence of soft margin
			MLnode_dist = find_ML_distance_to_source(statistic_parameters->likelihoodAll, p_infected_parameters, mpi_rank, &ML_node_id);
			source_rank = get_source_rank(statistic_parameters->likelihoodAll, p_infected_parameters); //source rank is writen in p_infected_parameters by collector node !
			FILE *fp = fopen("Likelihood_experiments_statistics.txt","a"); // no topological boost
			//"#SourceRank Phy_type Likelihood_type p q T delta_param MLdistance MLsourceID RealizationSize RandModel TopologicalBoost T_prior_low\n"
			fprintf(fp, "%d %d %d %lf %lf %d %d %d %d %d %d %d %d %d %d\n", source_rank, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method, epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->delta, MLnode_dist, ML_node_id, statistic_parameters->realization_size, p_infected_parameters->randomize_null_model_uniformly, 0, epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound , epidemicParameters_exp->T_start);
			fclose(fp);

			double * neighbourhood_prob = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
			calculate_neighbourhood_prob( neighbourhood_prob, statistic_parameters->likelihoodAll, p_infected_parameters ); //only for nodes that have non-zero source prob
			MLnode_dist = find_ML_distance_to_source(neighbourhood_prob, p_infected_parameters, mpi_rank, &ML_node_id);
			source_rank = get_source_rank(neighbourhood_prob, p_infected_parameters);
			export_source_prob(p_infected_parameters, neighbourhood_prob, fileRealizationsPath, exp_idx, input_args->no_of_iteration_per_cycle, input_args->input_file_name, likelihood_tmp, -1.0 );

			fp = fopen("Likelihood_experiments_statistics.txt","a"); // with topological boost
			fprintf(fp, "%d %d %d %lf %lf %d %d %d %d %d %d %d %d %d %d\n", source_rank, likelihood_tmp->phi_type, likelihood_tmp->likelihood_method, epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->delta, MLnode_dist, ML_node_id, statistic_parameters->realization_size, p_infected_parameters->randomize_null_model_uniformly, 1 , epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound, epidemicParameters_exp->T_start);
			fclose(fp);

			printf("Source rank : %d , size %d \n", source_rank, statistic_parameters->realization_size ); fflush(stdout);
			free(neighbourhood_prob);
		}

		free_mask_in_statistics_struct( statistic_parameters );
		free(mask_list);

	}else{
		MPI_Barrier(MPI_COMM_WORLD);
		//sync mask
		int mask_list_size;
		MPI_Bcast( &mask_list_size, 1, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
		int *mask_list = (int *) malloc( mask_list_size * sizeof(int) ); //***HEAP-MEMORY SAFE
		MPI_Bcast ( mask_list, mask_list_size, MPI_INT, MASTER_PROCESS_ID, MPI_COMM_WORLD);
		copy_mask_to_statistics_struct( mask_list, mask_list_size, statistic_parameters, p_infected_parameters);
		mpi_rank = worker_process_likelihood_singles( mpi_rank, input_args, p_infected_parameters, statistic_parameters ,epidemicParameters_exp, likelihood_tmp);
		free_mask_in_statistics_struct( statistic_parameters );
		free(mask_list);
	}

}


void copy_mask_to_statistics_struct(int * mask_list, int mask_list_size, statistics * statistic_parameters, infected_structure * p_infected_parameters){


	igraph_vector_t * mask = (igraph_vector_t *) malloc(sizeof (igraph_vector_t)); //***HEAP SAFE ?
	igraph_vector_init(mask, p_infected_parameters->no_of_nodes );
	for(int i = 0; i < mask_list_size; ++i){
		VECTOR(*mask)[mask_list[i]] = 1;
	}

	statistic_parameters->mask = mask;
	statistic_parameters->use_mask = 1;

}

void generate_mask(igraph_vector_t *mask, double mask_bit_prob){

	for(int i=0; i < igraph_vector_size(mask); ++i){
		if ( my_random() <= mask_bit_prob){
			VECTOR(*mask)[i] = 1;
		}else{
			VECTOR(*mask)[i] = 0;
		}
	}
}

void make_experiment_log(int mpi_rank, int exp_id, int master_generate_real, input *input_args, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics *statistic_parameters, likelihood_struct * likelihood_tmp){

	if (mpi_rank == MASTER_PROCESS_ID) {
		FILE *fp = fopen("Experiment_log.txt","a");
		fprintf(fp, "Master LOG ********** experiment %d  \n", exp_id);
		fprintf(fp, "SIR Parameters p = %lf, q = %lf \n", epidemicParameters_exp->p, epidemicParameters_exp->q);
		fprintf(fp, "SIR Parameters T = %d, T_start = %d, T_rel_start %d, T_end %d, T_rel_end %d \n", epidemicParameters_exp->T, epidemicParameters_exp->T_start, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_end, epidemicParameters_exp->T_rel_end);
		fprintf(fp, "SIR Parameters estimate_T_from_temporal_contacts = %d, randomize_parameters = %d \n ", epidemicParameters_exp->estimate_T_from_temporal_contacts, epidemicParameters_exp->randomize_parameters);
		fprintf(fp, "SIR Parameters prior lower bound = %d, prior higher bound = %d \n ", epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound );

		if ( master_generate_real == MASTER_GENERATE_REALIZATION ){
			fprintf(fp, "MASTER_GENERATE_REALIZATION \n");
		}else{
			fprintf(fp, "MASTER_READ_REALIZATION \n");
		}
		fprintf(fp, "Network %s \n", input_args->input_file_name);
		fprintf(fp, "Network type:  temporal_network %d, weighted_static_network %d \n", p_infected_parameters->use_temporal_network_structure, p_infected_parameters->use_weighted_static_network);
		fprintf(fp, "Network parameters: randomize_temporal_contacts %d, randomize uniformly %d , delta %d \n", p_infected_parameters->randomize_temporal_contacts, p_infected_parameters->randomize_null_model_uniformly, p_infected_parameters->delta);

		fprintf(fp, "source node %d \n", p_infected_parameters->start_node);

		fclose(fp);

		MPI_Barrier(MPI_COMM_WORLD);
		MPI_Barrier(MPI_COMM_WORLD);

	}else if (mpi_rank == COLLECTOR_PROCESS_ID){

		MPI_Barrier(MPI_COMM_WORLD);

		FILE *fp = fopen("Experiment_log.txt","a");
		fprintf(fp, "COLLECTOR LOG ********** experiment %d  \n", exp_id);
		fprintf(fp, "SIR Parameters p = %lf, q = %lf \n", epidemicParameters_exp->p, epidemicParameters_exp->q);
		fprintf(fp, "SIR Parameters T = %d, T_start = %d, T_rel_start %d, T_end %d, T_rel_end %d \n", epidemicParameters_exp->T, epidemicParameters_exp->T_start, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_end, epidemicParameters_exp->T_rel_end);
		fprintf(fp, "SIR Parameters estimate_T_from_temporal_contacts = %d, randomize_parameters = %d \n ", epidemicParameters_exp->estimate_T_from_temporal_contacts, epidemicParameters_exp->randomize_parameters);
		fprintf(fp, "SIR Parameters prior lower bound = %d, prior higher bound = %d \n ", epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound );

		fprintf(fp, "Network %s \n", input_args->input_file_name);
		fprintf(fp, "Network type:  temporal_network %d, weighted_static_network %d \n", p_infected_parameters->use_temporal_network_structure, p_infected_parameters->use_weighted_static_network);
		fprintf(fp, "Network parameters: randomize_temporal_contacts %d, randomize uniformly %d , delta %d \n", p_infected_parameters->randomize_temporal_contacts, p_infected_parameters->randomize_null_model_uniformly, p_infected_parameters->delta);

		fprintf(fp, "source node %d \n", p_infected_parameters->start_node);

		fclose(fp);

		MPI_Barrier(MPI_COMM_WORLD);


	}else{

		MPI_Barrier(MPI_COMM_WORLD);
		MPI_Barrier(MPI_COMM_WORLD);

		if ((mpi_rank > COLLECTOR_PROCESS_ID)&&(mpi_rank <= COLLECTOR_PROCESS_ID+1)){ //we need only one worker
			FILE *fp = fopen("Experiment_log.txt","a");
			fprintf(fp, "WORKER LOG ********** experiment %d  \n", exp_id);
			fprintf(fp, "SIR Parameters p = %lf, q = %lf \n", epidemicParameters_exp->p, epidemicParameters_exp->q);
			fprintf(fp, "SIR Parameters T = %d, T_start = %d, T_rel_start %d, T_end %d, T_rel_end %d \n", epidemicParameters_exp->T, epidemicParameters_exp->T_start, epidemicParameters_exp->T_rel_start, epidemicParameters_exp->T_end, epidemicParameters_exp->T_rel_end);
			fprintf(fp, "SIR Parameters estimate_T_from_temporal_contacts = %d, randomize_parameters = %d \n ", epidemicParameters_exp->estimate_T_from_temporal_contacts, epidemicParameters_exp->randomize_parameters);
			fprintf(fp, "SIR Parameters prior lower bound = %d, prior higher bound = %d \n ", epidemicParameters_exp->prior_T_low_bound, epidemicParameters_exp->prior_T_high_bound );

			fprintf(fp, "Network %s \n", input_args->input_file_name);
			fprintf(fp, "Network type:  temporal_network %d, weighted_static_network %d \n", p_infected_parameters->use_temporal_network_structure, p_infected_parameters->use_weighted_static_network);
			fprintf(fp, "Network parameters: randomize_temporal_contacts %d, randomize uniformly %d , delta %d \n", p_infected_parameters->randomize_temporal_contacts, p_infected_parameters->randomize_null_model_uniformly, p_infected_parameters->delta);

			fprintf(fp, "likelihood method %d, param1 %lf, param2 %lf, phi %d \n \n", likelihood_tmp->likelihood_method, likelihood_tmp->likelihood_param.first, likelihood_tmp->likelihood_param.second, likelihood_tmp->phi_type);

			fclose(fp);
		}
	}

}

void check_master_realization_acitvities(infected_structure * p_infected_parameters, vector<int> * node_activity_times, contagion_param_struct * epidemicParameters_exp,int node_target){

	if (p_infected_parameters->use_temporal_network_structure == 1){

		for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i ){
			if (p_infected_parameters->time_contact_array->at(i) < epidemicParameters_exp->T_end){
				if ((p_infected_parameters->contact_array_1->at(i) == node_target) || (p_infected_parameters->contact_array_2->at(i) == node_target)){  // node is active
					if (p_infected_parameters->time_contact_array->at(i) >= epidemicParameters_exp->prior_T_low_bound){ //prior knowledge
						node_activity_times->push_back( p_infected_parameters->time_contact_array->at(i) ); //report time activity
					}
				}else{
					continue; //node is not active at this step
				}
			}else{
				break;
			}
		}

		if (node_activity_times->size() == 0){
			printf("***MASTER error_ No nodes activities for node %d were found prior to %d in check_master_realization_acitvities() \n", node_target, epidemicParameters_exp->prior_T_low_bound);
			fflush(stdout);
			return;
		}

	}
}

void validate_temporal_null_model(int mpi_rank, infected_structure * p_infected_structure_null, infected_structure * p_infected_structure_orig, int T_end){

	if ((p_infected_structure_null->delta == 0)||(p_infected_structure_null->use_temporal_network_structure == 0)){
		return; //do not need to check
	}

	int T_start_idx_orig = 0; int T_end_idx_orig = 0;
	// go through the original and check whether null model is valid
	for(int tmp_T_start = p_infected_structure_orig->zero_time; tmp_T_start < T_end; tmp_T_start += p_infected_structure_null->delta){
		int tmp_T_end = tmp_T_start + p_infected_structure_null->delta - 1;
		if(tmp_T_end >= T_end){
			tmp_T_end = T_end;
		}

		//find end index
		while( p_infected_structure_orig->time_contact_array->at(T_end_idx_orig) <= tmp_T_end){
			T_end_idx_orig++;
		}
		T_end_idx_orig--;

		//check p_infected_structure_null between index [T_start_idx_orig, T_end_idx_orig] and validate that all contacts have time between [tmp_T_start, tmp_T_end]
		for(int i =  T_start_idx_orig; i <= T_end_idx_orig; ++i){
			int tmp_T_null = p_infected_structure_null->time_contact_array->at(i);
			if ((tmp_T_null > tmp_T_end) || (tmp_T_null < tmp_T_start)){
				printf("ERROR: CONTACT TIMES ARE NOT VALID W.R.T NULL MODEL !!!  \n"); fflush(stdout);
				exit(-1);
			}
		}

		//for each contact in p_infected_structure_null between index [T_start_idx_orig, T_end_idx_orig] find correspondig contact in p_infected_structure_orig between index [T_start_idx_orig, T_end_idx_orig]
		for(int i =  T_start_idx_orig; i <= T_end_idx_orig; ++i){
			int tmp_node_1_null = p_infected_structure_null->contact_array_1->at(i);
			int tmp_node_2_null = p_infected_structure_null->contact_array_2->at(i);

			//find corresponding contact
			int found_flag = 0;
			for (int j = T_start_idx_orig; j <= T_end_idx_orig; ++j){
				if (( p_infected_structure_orig->contact_array_1->at(j) == tmp_node_1_null ) && (p_infected_structure_orig->contact_array_2->at(j) == tmp_node_2_null)){
					found_flag = 1;
					break;
				}
			}
			if (found_flag == 0){
				printf("ERROR: CONTACT STRUCTURE NOT VALID W.R.T ORIGINAL DATA IN validate_temporal_null_model() !!!  \n"); fflush(stdout);
				exit(-1);
			}
		}


		T_start_idx_orig = T_end_idx_orig + 1;
	}


	if ((mpi_rank > COLLECTOR_PROCESS_ID)&&(mpi_rank <= COLLECTOR_PROCESS_ID+1)){ //we need only one worker
		printf("NULL model validated: structure and time ok ! \n"); fflush(stdout);
	}

}

void calculate_neighbourhood_prob(double * neighbourhood_prob, double * likelihood, infected_structure * p_infected_parameters){
	// CAUTION: BE AWARE HOW TO CALCULATE neighbourhood_prob VIA likelihood

	double likelihood_sum = 0.0;
	for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
		neighbourhood_prob[i] = likelihood[i];
		likelihood_sum += likelihood[i];
	}
	// neighbourhood_prob == likelihood

	tranform_to_proability_distr(neighbourhood_prob, p_infected_parameters);
	// neighbourhood_prob == prob_distribution of likelihood
	if (p_infected_parameters -> use_weighted_static_network == 0){
		printf("Neighbourhood calculated on static network or aggregated temporal \n"); fflush(stdout);
		igraph_vector_t neis;
		igraph_vector_init ( &neis, p_infected_parameters->no_of_nodes);
		for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
			int node_i = i;
			if (neighbourhood_prob[i] > 0.0){
				igraph_vector_null(&neis);
				igraph_neighbors(p_infected_parameters->p_graph, &neis, (igraph_integer_t) node_i, IGRAPH_ALL);
				for(int j = 0; j < igraph_vector_size(&neis); ++j){ // sum for all the neighbours, value for itself has at begining
					int node_j = (long int) VECTOR(neis)[j];
					neighbourhood_prob[node_i] += (likelihood[node_j] / likelihood_sum);
				}
			}
		}
		igraph_vector_destroy(&neis);
	}else{ //we will use a weighted sum of neighbours
		printf("Neighbourhood on weighted network \n"); fflush(stdout);
		for(int node_i = 0; node_i < p_infected_parameters->no_of_nodes; ++node_i){
			igraph_vector_t *neis = igraph_adjlist_get(p_infected_parameters->al, node_i);
			igraph_real_t no_of_neigh = igraph_vector_size(neis);
			for (int i = 0; i < no_of_neigh; ++i) {
				long int current_neigh = (long int) VECTOR(*neis)[i];
				double w_tmp = (double) igraph_spmatrix_e( p_infected_parameters->weight_mat, node_i, current_neigh);
				neighbourhood_prob[node_i] += (w_tmp * (likelihood[current_neigh] / likelihood_sum) );
			}

		}
	}

	/* OLD WRONG VERSION
	for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
		neighbourhood_prob[i] = likelihood[i];
	}

	tranform_to_proability_distr(neighbourhood_prob, p_infected_parameters);
	if (p_infected_parameters -> use_weighted_static_network == 0){
		printf("Neighbourhood on static network \n"); fflush(stdout);
		igraph_vector_t neis;
		igraph_vector_init ( &neis, p_infected_parameters->no_of_nodes);
		for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
			int node_i = i;
			if (neighbourhood_prob[i] > 0.0){
				igraph_vector_null(&neis);
				igraph_neighbors(p_infected_parameters->p_graph, &neis, (igraph_integer_t) node_i, IGRAPH_ALL);
				for(int j = 0; j < igraph_vector_size(&neis); ++j){ // sum for all the neighbours, value for itself has at begining
					int node_j = (long int) VECTOR(neis)[j];
					neighbourhood_prob[node_i] += neighbourhood_prob[node_j];
				}
			}
		}
	igraph_vector_destroy(&neis);
	}else{ //we will use a weighted sum of neighbours
		for(int node_i = 0; node_i < p_infected_parameters->no_of_nodes; ++node_i){
			igraph_vector_t *neis = igraph_adjlist_get(p_infected_parameters->al, node_i);
			igraph_real_t no_of_neigh = igraph_vector_size(neis);
			for (int i = 0; i < no_of_neigh; ++i) {
				long int current_neigh = (long int) VECTOR(*neis)[i];
				double w_tmp = (double) igraph_spmatrix_e( p_infected_parameters->weight_mat, node_i, current_neigh);
				neighbourhood_prob[node_i] += (w_tmp * neighbourhood_prob[current_neigh]);
			}

		}
	}
	*/

}

void find_potential_candidates(infected_structure * p_infected_parameters, igraph_vector_t * realization, igraph_vector_t * mask, igraph_vector_t * realization_candidates){

	for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
		if (VECTOR(*mask)[i] == 1){ // node is sensor
			VECTOR(*realization_candidates)[i] = VECTOR(*realization)[i]; //just copy the state of sensor
		}else{ // node is potential candidates if we find at least one infected node in one of his neighbourhoods by traversing only through non-sensor nodes
			igraph_vector_t node_flags_dfs;
			igraph_vector_init(&node_flags_dfs, p_infected_parameters->no_of_nodes);
			//VECTOR(node_flags_dfs)[i] = 1;
			VECTOR(*realization_candidates)[i] = DFS_find_inf_neighbour(p_infected_parameters, &node_flags_dfs, realization, mask, i);
			igraph_vector_destroy(&node_flags_dfs);
		}
	}
}

int DFS_find_inf_neighbour(infected_structure * p_infected_parameters, igraph_vector_t *node_flags_dfs, igraph_vector_t * realization, igraph_vector_t * mask, int node_tmp){

	int result = 0;
	VECTOR(*node_flags_dfs)[node_tmp] = 1; // visit

	if (VECTOR(*mask)[node_tmp] == 1){ // node is sensor
		if (VECTOR(*realization)[node_tmp] == 1){
			return 1;
		}else if (VECTOR(*realization)[node_tmp] == 0){
			return 0;
		}
	}else{ // node is not sensor -> state ? unkown
		igraph_vector_t neis;
		igraph_vector_init ( &neis, p_infected_parameters->no_of_nodes);
		igraph_neighbors(p_infected_parameters->p_graph, &neis, (igraph_integer_t) node_tmp, IGRAPH_ALL);
		for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
				int neigh_tmp = (long int) VECTOR(neis)[i];
				if (VECTOR(*node_flags_dfs)[neigh_tmp] == 0){ // not visited
					int tmp_res = DFS_find_inf_neighbour(p_infected_parameters, node_flags_dfs, realization, mask, neigh_tmp);
					/*// memory problem, we return a value before we release neis structure
					 if (tmp_res == 1){
						return 1;
					}else{
						result += tmp_res;
					}
					*/
					result += tmp_res;
				}
		}
		igraph_vector_destroy(&neis);
	}

	result = (result>0) ? 1 : 0;
	return result;
}

void tranform_to_proability_distr(double * likelihood, infected_structure * p_infected_parameters){

	double norm_sum = 0.0;
	for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
			norm_sum += likelihood[i];
	}

	if (norm_sum > 0.0){
		for(int i = 0; i < p_infected_parameters->no_of_nodes; ++i){
			likelihood[i] = likelihood[i] / norm_sum;
		}
	}else if (norm_sum == 0.0){
		//nothing no normalization
	}else{
		printf("EROOR in tranform_to_proability_distr(), norm_sum is not positive !\n"); fflush(stdout);
		exit(-1);
	}
}

int get_source_rank(double * likelihood, infected_structure * p_infected_parameters){
// CAUTION: be sure that current collector,worker, master has the right value p_infected_parameters->start_node

	double source_score = likelihood[p_infected_parameters->start_node];

	// find position in the ranked list
	int betterRanked_nodes = 0;
	for( int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
		if ( likelihood[i] >= source_score ){
			betterRanked_nodes++;
		}
	}

	return betterRanked_nodes;
}

int find_ML_distance_to_source(double * likelihood, infected_structure * p_infected_parameters, int mpi_rank, int * ML_node_id){

	int source_node_id = p_infected_parameters->start_node; // for collector and master only
	if ((mpi_rank != COLLECTOR_PROCESS_ID) && (mpi_rank != MASTER_PROCESS_ID)){
		printf("WARNING: calculating distance from p_infected_parameters->start_node for worker are you sure this is the right source ?: find_ML_distance_to_source()!!!");
		return -1;
	}
	printf("source node in find_ML_distance_to_source() is %d \n", source_node_id); fflush(stdout);


	igraph_matrix_t * geodesic_paths; //***HEAP-MEMORY SAFE
	geodesic_paths = (igraph_matrix_t *) malloc(sizeof(igraph_matrix_t));
	igraph_matrix_init( geodesic_paths, 1, p_infected_parameters->no_of_nodes);

	//for temporal networks aggregated network is in p_infected_parameters->p_graph
	if (p_infected_parameters->p_graph == NULL){
		printf("ERROR: Network pointer is NULL: find_ML_distance_to_source() \n");
		return -1;
	}
	//igraph_shortest_paths(p_infected_parameters->p_graph, geodesic_paths, igraph_vss_1((igraph_integer_t) source_node_id), IGRAPH_ALL);

	#ifdef IGRAPH_VERSION_0_6_5
	igraph_shortest_paths( p_infected_parameters->p_graph, geodesic_paths, igraph_vss_1((igraph_integer_t) source_node_id), igraph_vss_all(), IGRAPH_ALL);
	#else
	igraph_shortest_paths( p_infected_parameters->p_graph, geodesic_paths, igraph_vss_1((igraph_integer_t) source_node_id), IGRAPH_ALL);
	#endif

	//find ML node
	int MLnode_idx = -1; double max_prob = 0.0;
	for( int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
		if ( likelihood[i] >= max_prob ){
			max_prob = likelihood[i];
			MLnode_idx = i;
		}
	}

	int ML_dist = (double) MATRIX( *geodesic_paths, 0, (int) MLnode_idx );
	*ML_node_id = MLnode_idx;

	igraph_matrix_destroy( geodesic_paths );

	return ML_dist;
}

int find_diameter_temporal_subgraph(infected_structure * p_infected_parameters, igraph_vector_t * infected_nodes){

	igraph_t subgraph_inf;
	igraph_empty(&subgraph_inf, (igraph_integer_t) p_infected_parameters->no_of_nodes, IGRAPH_UNDIRECTED);
	find_infected_subgraph_temporal(p_infected_parameters, infected_nodes, &subgraph_inf);

	igraph_integer_t diam;

	igraph_diameter(&subgraph_inf, &diam, 0,0,0, IGRAPH_UNDIRECTED, 1);

	return (int) diam;
}


int getRandomNodeFromPeriod(infected_structure * p_infected_parameters, int T_rel_sample_start, int T_rel_sample_end, int *source_time){

	vector<int> nodes_from_period;
	vector<int> nodes_time_from_period;
	int T_start_sample = p_infected_parameters->zero_time + T_rel_sample_start;
	int T_end_sample = p_infected_parameters->zero_time + T_rel_sample_end;


	for (int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){
		//printf(" %d ", p_infected_parameters->time_contact_array->at(i));
		if ( (p_infected_parameters->time_contact_array->at(i) >= T_start_sample) && (p_infected_parameters->time_contact_array->at(i) <= T_end_sample) ) {
			nodes_from_period.push_back( p_infected_parameters->contact_array_1->at(i) ); //females
			nodes_from_period.push_back( p_infected_parameters->contact_array_2->at(i) ); //males
			nodes_time_from_period.push_back( p_infected_parameters->time_contact_array->at(i) );
			nodes_time_from_period.push_back( p_infected_parameters->time_contact_array->at(i) );
		}
	}

	if (nodes_from_period.size() == 0){ // no active node from that period, find first interaction after
		for (int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){
			if ( (p_infected_parameters->time_contact_array->at(i) >= T_start_sample) ) {
				nodes_from_period.push_back( p_infected_parameters->contact_array_1->at(i) ); //females
				nodes_from_period.push_back( p_infected_parameters->contact_array_2->at(i) ); //males
				nodes_time_from_period.push_back( p_infected_parameters->time_contact_array->at(i) );
				nodes_time_from_period.push_back( p_infected_parameters->time_contact_array->at(i) );
				break;
			}
		}
	}

	//printf("Sampled %d nodes from period %d to %d, total num of contacts %d \n", nodes_from_period.size(), T_start_sample, T_end_sample, p_infected_parameters->contact_array_1->size());
	int rnd_idx = getRandomNode(nodes_from_period.size()-1);
	int rnd_node = nodes_from_period.at(rnd_idx);
	*source_time = nodes_time_from_period.at(rnd_idx);
	nodes_from_period.clear();
	nodes_time_from_period.clear();
	return rnd_node;
}

/*
int getRandomUniformNodeFromPeriod(infected_structure * p_infected_parameters, int T_rel_sample_start, int T_rel_sample_end, int *source_time){

	vector<int> nodes_from_period;
	vector<int> nodes_time_from_period;
	int T_start_sample = p_infected_parameters->zero_time + T_rel_sample_start;
	int T_end_sample = p_infected_parameters->zero_time + T_rel_sample_end;

	vector<int> * nodes_selected = new vector<int> ( p_infected_parameters->no_of_nodes );



	for (int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){
		//printf(" %d ", p_infected_parameters->time_contact_array->at(i));
		if ( (p_infected_parameters->time_contact_array->at(i) >= T_start_sample) && (p_infected_parameters->time_contact_array->at(i) <= T_end_sample) ) {
			nodes_from_period.push_back( p_infected_parameters->contact_array_1->at(i) ); //females
			nodes_from_period.push_back( p_infected_parameters->contact_array_2->at(i) ); //males
			nodes_time_from_period.push_back( p_infected_parameters->time_contact_array->at(i) );
			nodes_time_from_period.push_back( p_infected_parameters->time_contact_array->at(i) );
		}
	}

	//printf("Sampled %d nodes from period %d to %d, total num of contacts %d \n", nodes_from_period.size(), T_start_sample, T_end_sample, p_infected_parameters->contact_array_1->size());
	int rnd_idx = getRandomNode(nodes_from_period.size()-1);
	int rnd_node = nodes_from_period.at(rnd_idx);
	*source_time = nodes_time_from_period.at(rnd_idx);
	nodes_from_period.clear();
	nodes_time_from_period.clear();
	return rnd_node;
}
*/

void add_sim_num_for_benchmark_convergence(vector<long int> * num_simulations_array_exp, int exponent_size_min, int exponent_size_max){
// exponential growth of simulations
	long int num_sim = 1;
	for(int i = 0; i< exponent_size_min; ++i){
		num_sim *= 10;
	}

	//num_simulations_array_exp->push_back(num_sim);
	for(int i = (exponent_size_min); i < exponent_size_max; ++i){
		num_simulations_array_exp->push_back(num_sim*5);
		num_simulations_array_exp->push_back(num_sim*10);
		num_sim *= 10;
	}

}


void add_sim_num_for_phase1(vector<long int> * num_simulations_array_exp, int exponent_size_min, int exponent_size_max){

	long int num_sim = 1;
	for(int i = 0; i< exponent_size_min; ++i){
		num_sim *= 10;
	}

	for(int i = (exponent_size_min); i <= exponent_size_max; ++i){
		num_simulations_array_exp->push_back(num_sim);
		num_simulations_array_exp->push_back(num_sim + num_sim);
		num_sim *= 10;
	}

}

void add_likelihoods_to_benchmark(int benchmark_phase, vector<likelihood_struct> * likelihood_array){

	likelihood_struct likelihood_tmp;
	if (benchmark_phase == BENCHMARK_PHASE_1){
		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_UNBIASED_PRUNNING;
		likelihood_tmp.likelihood_param = make_pair(-1.0,-1.0);
		likelihood_array->push_back( likelihood_tmp );

	}else{



		/*
		 *
		likelihood_tmp.phi_type = PHI_JACCARD;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN;
		likelihood_tmp.likelihood_param = make_pair(0.125,-1.0);
		likelihood_array->push_back( likelihood_tmp );

		likelihood_tmp.phi_type = PHI_JACCARD;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN_PRUNING;
		likelihood_tmp.likelihood_param = make_pair(0.125, 0.6);
		likelihood_array->push_back( likelihood_tmp );
	*/


		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_RAND_UNIFORM;
		likelihood_tmp.likelihood_param = make_pair(-1.0, -1.0);
		likelihood_array->push_back( likelihood_tmp );

		likelihood_tmp.phi_type = PHI_JACCARD;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_AUCDF;
		likelihood_tmp.likelihood_param = make_pair(-1.0,-1.0);
		likelihood_array->push_back( likelihood_tmp );


		likelihood_tmp.phi_type = PHI_JACCARD;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_AVGTOPK;
		likelihood_tmp.likelihood_param = make_pair(0.05,-1.0);
		likelihood_array->push_back( likelihood_tmp );

		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_DISTANCE;
		likelihood_tmp.likelihood_param = make_pair(-1.0,-1.0);
		likelihood_array->push_back( likelihood_tmp );


		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_JORDAN;
		likelihood_tmp.likelihood_param = make_pair(-1.0,-1.0);
		likelihood_array->push_back( likelihood_tmp );

		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_DMP;
		likelihood_tmp.likelihood_param = make_pair(-1.0,-1.0);
		likelihood_array->push_back( likelihood_tmp );


		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_NAIVE;
		likelihood_tmp.likelihood_param = make_pair(0.00000001,-1.0);
		likelihood_array->push_back( likelihood_tmp );

		likelihood_tmp.phi_type = PHI_NONE;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_CONST_ALL;
		likelihood_tmp.likelihood_param = make_pair(-1.0, -1.0);
		likelihood_array->push_back( likelihood_tmp );



		likelihood_tmp.phi_type = PHI_JACCARD;
		likelihood_tmp.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN;
		double sigma = 1;
		for (int k = 1; k<=10; ++k){
			sigma = sigma / 2;
			likelihood_tmp.likelihood_param = make_pair(sigma,-1.0);
			likelihood_array->push_back( likelihood_tmp );
		}
	}

}

int get_rand_T_value_epsilon(double p_T_distr_param){
	// Geometric distribution with p_T_distr_param parameter

	int epsilon = 0;
	while( my_random() > p_T_distr_param ){
		epsilon++;
	}
	return epsilon;
}

void runMPI_detectability_experiment(int argc, char **argv){

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n");
		MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size);
	MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);

	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure

	likelihood_struct likelihood_fun;
	likelihood_fun.phi_type = PHI_JACCARD;
	likelihood_fun.likelihood_method = LIKELIHOOD_METHOD_SOFT_MARGIN;
	likelihood_fun.likelihood_param = make_pair(0.125,-1.0);

	int num_real_per_source = 100;
	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	init_static_parameters_detectability(p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_WEIGHTED_NET;
	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
	}

	vector<int> source_array_id;
	source_array_id.push_back(444); //Zagreb airport
	source_array_id.push_back(582); //LHR,London Heathrow Apt

	/*
	source_array_id.push_back(919); //ATL,Atlanta Hartsfield-Jackson Intl Apt
	source_array_id.push_back(183); //,PEK,Beijing Capital Apt
	source_array_id.push_back(766); //,CGH,Sao Paulo Congonhas Apt
	source_array_id.push_back(879); //,DXB,Dubai
	source_array_id.push_back(129); //,HND,Tokyo Haneda Apt
	source_array_id.push_back(426); //,SVO,Moscow Sheremetyevo International Apt
	source_array_id.push_back(1223); //,SYD,Sydney Kingsford Smith Apt
	source_array_id.push_back(1177); //,YYZ,Toronto Lester B Pearson Intl Apt
	source_array_id.push_back(827); //,BOG,Bogota
	source_array_id.push_back(1053); //,MEX,Mexico City Juarez International Apt
	source_array_id.push_back(205); //,TSA,Taipei Sung Shan Apt
	*/
	// *** Input parameters END

	//iterate over sources
	for(int source_idx = 0; source_idx< source_array_id.size(); source_idx++){
		p_infected_parameters->start_node = source_array_id.at(source_idx);
		if (mpi_rank == MASTER_PROCESS_ID) {
			printf("\n ******* Source %d \n", source_array_id.at(source_idx)); fflush( stdout );
		}

		//iterate over realizations
		for(int exp_idx = 0; exp_idx < num_real_per_source; exp_idx++){
				 if (mpi_rank == MASTER_PROCESS_ID) { printf("..%d",exp_idx); fflush( stdout ); }
				MPI_detectability_single_estimator( &input_args, mpi_rank, mpi_size, &epidemicParameters, p_infected_parameters, &statistic_parameters , &likelihood_fun );
		}

		if (mpi_rank == COLLECTOR_PROCESS_ID){
			double source_det_val = (double) igraph_spmatrix_e(statistic_parameters.detectability_mat, source_array_id.at(source_idx), source_array_id.at(source_idx));
			source_det_val = source_det_val / (double) num_real_per_source;
			printf("SOURCE %d detectability E(X) %lf \n", source_array_id.at(source_idx), source_det_val);
		}
	}

	if (mpi_rank == COLLECTOR_PROCESS_ID){
		normalize_detectabilty_matrix(&statistic_parameters, num_real_per_source);
		print_E_V_detectabilty_matrix_diagonal(&statistic_parameters, &source_array_id);
		double E_tmp = get_detectability_element(&statistic_parameters, source_array_id.at(0), source_array_id.at(1));
		double Var_tmp = get_detectability_element(&statistic_parameters, source_array_id.at(0), source_array_id.at(1));
		printf("Detectability E(X(%d,%d)) = %lf, Var %lf \n", source_array_id.at(0), source_array_id.at(1), E_tmp, Var_tmp );

		E_tmp = get_detectability_element(&statistic_parameters, source_array_id.at(1), source_array_id.at(0) );
		Var_tmp = get_detectability_element(&statistic_parameters, source_array_id.at(1), source_array_id.at(0));
		printf("Detectability E(X(%d,%d)) = %lf, Var %lf \n",source_array_id.at(1), source_array_id.at(0), E_tmp, Var_tmp );
		//print_detectabilty_matrix(&statistic_parameters, p_infected_parameters);
	}


	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	source_array_id.clear();
	MPI_Finalize();


}

void MPI_detectability_single_estimator(input *input_args, int mpi_rank, int mpi_size, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics * statistic_parameters, likelihood_struct * likelihood_tmp){

	MPI_Barrier(MPI_COMM_WORLD); //sync all machines

	double * likelihoodsAll;
	igraph_vector_t * realization_star;
	int source_node_id, no_of_inf_nodes;
	if (mpi_rank == MASTER_PROCESS_ID) {

		realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t)); //***HEAP-MEMORY SAFE
		igraph_vector_init ( realization_star, p_infected_parameters->no_of_nodes); //***HEAP-MEMORY SAFE
		struct timeval tv; gettimeofday(&tv, 0); unsigned seed = tv.tv_usec * getpid();

		run_contagion_model(p_infected_parameters, statistic_parameters->contagion_process_type, realization_star, epidemicParameters_exp, seed);
		no_of_inf_nodes = igraph_vector_sum(realization_star);

		//printf(" p: %f, q: %f , T: %d , Source: %d, realization size: %d \n ",epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->start_node, no_of_inf_nodes);
		int * nodes_set = (int *) malloc((no_of_inf_nodes+1) * sizeof(int)); //***HEAP-MEMORY SAFE
		int tmpNum = 0;
		for (int i=0; i< igraph_vector_size( realization_star ); ++i){
			if (VECTOR( *realization_star )[i]==1){
				nodes_set[tmpNum++] = i;
			}
		}

		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = master_process_likelihood_singles(mpi_size, mpi_rank, no_of_inf_nodes, nodes_set, source_node_id);
		free(nodes_set);
		igraph_vector_destroy( realization_star );
	} else if (mpi_rank == COLLECTOR_PROCESS_ID){
		//likelihoodsAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = collector_process_likelihood_singles(input_args, p_infected_parameters, mpi_rank, statistic_parameters, -1, likelihood_tmp);
		update_detectability_matrices(statistic_parameters, likelihoodsAll, p_infected_parameters);
		//free(likelihoodsAll);
	}else{
		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = worker_process_likelihood_singles( mpi_rank, input_args, p_infected_parameters, statistic_parameters, epidemicParameters_exp, likelihood_tmp);
	}

}

void get_synthetic_realization_test_net(vector<igraph_vector_t *> * realization_set){
// generatea all 16 realizaions for network with 4 nodes

	for(int node_1 = 0; node_1 <= 1; node_1++){
		for(int node_2 = 0; node_2 <= 1; node_2++){
			for(int node_3 = 0; node_3 <= 1; node_3++){
				for(int node_4 = 0; node_4 <= 1; node_4++){
					igraph_vector_t * realization_star = (igraph_vector_t *)  malloc(sizeof (igraph_vector_t));
					igraph_vector_init ( realization_star, 4);

					 VECTOR(*realization_star)[0] = node_1;
					 VECTOR(*realization_star)[1] = node_2;
					 VECTOR(*realization_star)[2] = node_3;
					 VECTOR(*realization_star)[3] = node_4;

					if ((node_1 + node_2 + node_3 + node_4) > 0){
						realization_set->push_back(realization_star);
					}
				}
			}
		}
	}

}

void destroy_realization_set(vector<igraph_vector_t *> * realization_set){
	for(int i = 0; i < realization_set->size(); ++i){
		igraph_vector_destroy(realization_set->at(i));
	}
	realization_set->clear();
}

void runMPI_detectability_synthetic_net_experiment(int argc, char **argv){
// testing the hypotheis D(i|j) < 1/n on a smal 4 size network

	int mpi_kontrola, mpi_size, mpi_rank;
	mpi_kontrola = MPI_Init(&argc, &argv);
	if (mpi_kontrola != MPI_SUCCESS) {
		printf("ERROR MPI COULD NOT START \n");
		MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
	}
	MPI_Comm_size(MPI_COMM_WORLD, &mpi_size);
	MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);

	// *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);

	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure

	likelihood_struct likelihood_fun;
	likelihood_fun.phi_type = PHI_JACCARD;
	likelihood_fun.likelihood_method = LIKELIHOOD_METHOD_UNBIASED_PRUNNING;
	likelihood_fun.likelihood_param = make_pair(-1.0,-1.0);

	int num_real_per_source = 15;
	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	init_static_parameters_detectability(p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_UNWEIGHTED_NET;
	if (mpi_rank == COLLECTOR_PROCESS_ID){ //put init inside init_statistic_parameters
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE ? NOT
	}


	vector<int> source_array_id;
	source_array_id.push_back(0);
	source_array_id.push_back(1);
	source_array_id.push_back(2);
	source_array_id.push_back(3);
	// *** Input parameters END


	//iterate over sources
	for(int source_idx = 0; source_idx< source_array_id.size(); source_idx++){
		p_infected_parameters->start_node = source_array_id.at(source_idx);
		if (mpi_rank == MASTER_PROCESS_ID) {
			printf("\n ******* Source %d \n", source_array_id.at(source_idx)); fflush( stdout );
		}

		//iterate over realizations
		for(int exp_idx = 0; exp_idx < num_real_per_source; exp_idx++){
				 if (mpi_rank == MASTER_PROCESS_ID) { printf("..%d",exp_idx); fflush( stdout ); }
				MPI_detectability_single_estimator_synthetic_net( &input_args, mpi_rank, mpi_size, &epidemicParameters, p_infected_parameters, &statistic_parameters , &likelihood_fun, exp_idx );
		}

		if (mpi_rank == COLLECTOR_PROCESS_ID){
			double source_det_val = (double) igraph_spmatrix_e(statistic_parameters.detectability_mat, source_array_id.at(source_idx), source_array_id.at(source_idx));
			printf("SOURCE %d detectability E(X) %lf \n", source_array_id.at(source_idx), source_det_val);
		}
	}

	if (mpi_rank == COLLECTOR_PROCESS_ID){
		//normalize_detectabilty_matrix(&statistic_parameters, num_real_per_source);
		print_E_V_detectabilty_matrix_diagonal(&statistic_parameters, &source_array_id);
		print_detectabilty_matrix(&statistic_parameters, p_infected_parameters);
		print_detectabilty_matrix_VAR(&statistic_parameters, p_infected_parameters);
	}


	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	source_array_id.clear();
	MPI_Finalize();

}

void MPI_detectability_single_estimator_synthetic_net(input *input_args, int mpi_rank, int mpi_size, contagion_param_struct * epidemicParameters_exp, infected_structure * p_infected_parameters, statistics * statistic_parameters, likelihood_struct * likelihood_tmp, int exp_id){

	MPI_Barrier(MPI_COMM_WORLD); //sync all machines

	double * likelihoodsAll;
	igraph_vector_t * realization_star;
	int source_node_id, no_of_inf_nodes;
	if (mpi_rank == MASTER_PROCESS_ID) {

		struct timeval tv; gettimeofday(&tv, 0); unsigned seed = tv.tv_usec * getpid();

		vector< igraph_vector_t *> * realization_set = new vector<igraph_vector_t *>(); //***HEAP-MEMORY SAFE
		get_synthetic_realization_test_net(realization_set);
		realization_star = realization_set->at(exp_id);
		no_of_inf_nodes = igraph_vector_sum(realization_star);

		printf(" p: %f, q: %f , T: %d , Source: %d, realization size: %d \n ",epidemicParameters_exp->p, epidemicParameters_exp->q, epidemicParameters_exp->T, p_infected_parameters->start_node, no_of_inf_nodes);
		int * nodes_set = (int *) malloc((no_of_inf_nodes+1) * sizeof(int)); //***HEAP-MEMORY SAFE
		int tmpNum = 0;
		for (int i=0; i< igraph_vector_size( realization_star ); ++i){
			if (VECTOR( *realization_star )[i]==1){
				nodes_set[tmpNum++] = i;
			}
		}

		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = master_process_likelihood_singles(mpi_size, mpi_rank, no_of_inf_nodes, nodes_set, source_node_id);
		free(nodes_set);
		igraph_vector_destroy( realization_star );
		destroy_realization_set(realization_set);
	} else if (mpi_rank == COLLECTOR_PROCESS_ID){
		//likelihoodsAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = collector_process_likelihood_singles(input_args, p_infected_parameters, mpi_rank , statistic_parameters, -1, likelihood_tmp);
		update_detectability_matrices_by_def(statistic_parameters, likelihoodsAll, p_infected_parameters);
		//free(likelihoodsAll);
	}else{
		MPI_Barrier(MPI_COMM_WORLD);
		mpi_rank = worker_process_likelihood_singles( mpi_rank, input_args, p_infected_parameters, statistic_parameters, epidemicParameters_exp, likelihood_tmp);
	}

}

void run_MPI_pruning_speed_experiment(int argc, char **argv) {

	int mpi_kontrola, mpi_size, mpi_rank;
    mpi_kontrola = MPI_Init(&argc, &argv);
    if (mpi_kontrola != MPI_SUCCESS) {
        printf("ERROR MPI COULD NOT START \n");
        MPI_Abort(MPI_COMM_WORLD, mpi_kontrola);
    }
    MPI_Comm_size(MPI_COMM_WORLD, &mpi_size);
    MPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);
    // *** Input parameters START
	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);

	vector<double> T_distr_experiments, P_distr_experiments, Q_distr_experiments;
	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure

	int exp_low_id = 0;
	int exp_high_id = 1;
	int benchmark_phase = BENCHMARK_PHASE_2;
	vector<long int> num_simulations_array_exp;
	if ( benchmark_phase == BENCHMARK_PHASE_1 ){
		//add_sim_num_for_benchmark_convergence(&num_simulations_array_exp, 7, 8); //exponential growth
		add_sim_num_for_phase1(&num_simulations_array_exp, 5, 5); // linear growth + exponential
	}else{
		add_sim_num_for_benchmark_convergence(&num_simulations_array_exp, 3, 8);
	}

	vector<likelihood_struct> likelihood_array;
	add_likelihoods_to_benchmark(benchmark_phase, &likelihood_array);
	char *fileBenchMarkPath = BENCHMARK_FILE_PATH;

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_UNWEIGHTED_NET;
	double * likelihood_last = NULL;
	if (mpi_rank == COLLECTOR_PROCESS_ID){
		statistic_parameters.likelihoodAll = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
		likelihood_last = (double *)  malloc( (p_infected_parameters->no_of_nodes) * sizeof(double)); // *** HEAP MEMORY SAFE
	}

	// *** Input parameters END

	int master_generate_real;
	for( int estimator_idx = 0; estimator_idx < likelihood_array.size(); estimator_idx++){
		for(int exp_idx = exp_low_id; exp_idx < exp_high_id; exp_idx++){
			for ( int sim_num_idx = 0; sim_num_idx < num_simulations_array_exp.size(); sim_num_idx++){
				if ((sim_num_idx == 0) && (benchmark_phase == BENCHMARK_PHASE_1) ){ // First time generate realization
					master_generate_real = MASTER_GENERATE_REALIZATION;
				}else{ // read realization
					master_generate_real = MASTER_READ_REALIZATION;
				}
				input_args.no_of_iteration_per_cycle = num_simulations_array_exp.at(sim_num_idx);
				statistic_parameters.no_of_iteration_per_cycle = num_simulations_array_exp.at(sim_num_idx);

				MPI_benchmark_single_estimator_single_exp( &input_args, mpi_rank, mpi_size, exp_idx, master_generate_real , &epidemicParameters , p_infected_parameters, &statistic_parameters ,&likelihood_array.at(estimator_idx) ,fileBenchMarkPath);
			}
		}// experiments for pq values
	} // likelihood estimators

	if (likelihood_last != NULL){ free(likelihood_last); }
	num_simulations_array_exp.clear();
	P_distr_experiments.clear();
	Q_distr_experiments.clear();
	T_distr_experiments.clear();
	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	likelihood_array.clear();
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
	MPI_Finalize();
}
